#!/usr/bin/env python3
#-*- encoding=utf8 -*-
import os
from tkinter import *
from tkinter import font
# Textdatei
import sys
sys.path.insert(0, 'daten')
from textdaten import datensammlung
import webbrowser

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame, pady=4, padx=2)
        self.frame2=Frame(frame, pady=4, padx=2)
        self.frame3=Frame(frame, pady=4, padx=2)
        for f, row, column, columnspan, sticky in (
                (frame,       0, 0, 1, E+W),
                (self.frame1, 0, 0, 1, E+W),
                (self.frame2, 1, 0, 1, E+W),
                (self.frame3, 2, 1, 1, E+W)
                ):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        # Rahmen 1: Auswahl des eigenen Blutgruppe und Folgen für die Blutempfänger-Eigenschaften,
        #           Auswahl der Blutgruppe eines Elternteils und Rückschluss auf mögliche
        #           Blutgruppen des anderen Elternteils
        self.f1l1=Label(self.frame1, text='Eigene Blutgruppe:', anchor=E)
        global eigene 
        eigene=StringVar()
        eigene.set('X')
        self.f1r1=Radiobutton(self.frame1, variable=eigene, value='A', text='„A”', command=self.setze_eigene)
        self.f1r2=Radiobutton(self.frame1, variable=eigene, value='B', text='„B”', command=self.setze_eigene)
        self.f1r3=Radiobutton(self.frame1, variable=eigene, value='AB', text='„AB”', command=self.setze_eigene)
        self.f1r4=Radiobutton(self.frame1, variable=eigene, value='0', text='„0”', command=self.setze_eigene)
        self.f1l2=Label(self.frame1, text='Mögliche Genotypen:', anchor=E)
        self.f1e1=Entry(self.frame1, width=20, bg='white')
        self.f1l3=Label(self.frame1, text='Antigene auf den\nroten Blutkörperchen:', anchor=E, justify=RIGHT)
        self.f1canvas1=Canvas(self.frame1, width=160, height=160, bg='white')
        self.f1l4=Label(self.frame1, text='Antikörper im\nBlutserum:', anchor=E, justify=RIGHT)
        self.f1canvas2=Canvas(self.frame1, width=160, height=160, bg='white')
        self.f1l5=Label(self.frame1, text='Mögliche Blut-Spenderblutgruppen:', anchor=E)
        self.f1e2=Entry(self.frame1, width=20, bg='white')
        self.f1l6=Label(self.frame1, text='Mögliche Plasma-Spenderblutgruppen:', anchor=E)
        self.f1e3=Entry(self.frame1, width=20, bg='white')
        self.f1l7=Label(self.frame1, text='Blutgruppe des einen Elternteils:', anchor=E)
        global elter_1
        elter_1=StringVar()
        elter_1.set('X')
        self.f1r5=Radiobutton(self.frame1, variable=elter_1, value='A', text='„A”', command=self.setze_elter_1)
        self.f1r6=Radiobutton(self.frame1, variable=elter_1, value='B', text='„B”', command=self.setze_elter_1)
        self.f1r7=Radiobutton(self.frame1, variable=elter_1, value='AB', text='„AB”', command=self.setze_elter_1)
        self.f1r8=Radiobutton(self.frame1, variable=elter_1, value='0', text='„0”', command=self.setze_elter_1)
        self.f1l8=Label(self.frame1, text='Mögliche Blutgruppen des anderen Elternteils:', anchor=E)
        self.f1e4=Entry(self.frame1, width=20, state=DISABLED)

        # Rahmen 2: Navigation
        icon_reset = PhotoImage(file='daten/icons/view-refresh.gif')
        self.f2b1=Button(self.frame2, 
                         text='Zurücksetzen', 
                         command=self.zurueck_setzen,
                         image=icon_reset,
                         compound=LEFT)
        self.f2b1.icon_reset=icon_reset
        icon_exit = PhotoImage(file='daten/icons/dialog-close.gif')
        self.f2b2=Button(self.frame2, 
                         text='Beenden', 
                         command=root.destroy,
                         image=icon_exit,
                         compound=LEFT)
        self.f2b2.icon_exit=icon_exit

        # Fensterelemente setzen
        for i, row, column, columnspan, sticky in (
                # Rahmen 1
                (self.f1l1, 0, 0, 1, E+W), (self.f1r1, 0, 1, 1, E+W), (self.f1r2, 0, 2, 1, E+W), (self.f1r3, 0, 3, 1, E+W), (self.f1r4, 0, 4, 1, E+W),
                (self.f1l2, 1, 0, 1, E+W), (self.f1e1, 1, 1, 4, E+W),
                (self.f1l3, 2, 0, 1, E+W), (self.f1canvas1, 2, 1, 4, W),
                (self.f1l4, 3, 0, 1, E+W), (self.f1canvas2, 3, 1, 4, W),
                (self.f1l5, 4, 0, 1, E+W), (self.f1e2, 4, 1, 4, E+W),
                (self.f1l6, 5, 0, 1, E+W), (self.f1e3, 5, 1, 4, E+W),
                (self.f1l7, 6, 0, 1, E+W), (self.f1r5, 6, 1, 1, E+W), (self.f1r6, 6, 2, 1, E+W), (self.f1r7, 6, 3, 1, E+W), (self.f1r8, 6, 4, 1, E+W),
                (self.f1l8, 7, 0, 1, E+W), (self.f1e4, 7, 1, 4, E+W),
                # Rahmen 2
                (self.f2b1, 0, 0, 1, E+W), (self.f2b2, 0, 1, 1, E+W)):
            i.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        self.eingabefelder=(self.f1e1, self.f1e2, self.f1e3, self.f1e4)
        self.anfang_inaktiv=(self.f1e1, self.f1e2, self.f1e3, self.f1e4,
                             self.f1r5, self.f1r6, self.f1r7, self.f1r8,
                             self.f1l2,
                             self.f1l3,
                             self.f1l4,
                             self.f1l5,
                             self.f1l6,
                             self.f1l7,
                             self.f1l8)
        for i in self.anfang_inaktiv:
            i.config(state=DISABLED)

        ##  Funktionen  ########################################################

    def zurueck_setzen(self):
        eigene.set('X')
        elter_1.set('X')
        for i in self.eingabefelder:
            i.config(state=NORMAL)
            i.delete(0, END)
        for i in self.anfang_inaktiv:
            i.config(state=DISABLED)
        # Bild 1
        for i in self.f1canvas1.find_all():
            self.f1canvas1.delete(i)
        self.bild1=PhotoImage(file='daten/img/start.gif')
        self.f1canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
        self.f1canvas1.update()
        # Bild 2
        for i in self.f1canvas2.find_all():
            self.f1canvas2.delete(i)
        self.bild2=PhotoImage(file='daten/img/start.gif')
        self.f1canvas2.create_image(0, 0, image=self.bild2, anchor=NW)
        self.f1canvas2.update()
        print('zurueck_setzen')

    def setze_eigene(self):
        self.eigene=str(eigene.get())
        self.moegliche_genotypen=str(datensammlung[self.eigene][0])
        self.moegliche_blutspendergruppen=str(datensammlung[self.eigene][1])
        self.moegliche_plasmaspendergruppen=str(datensammlung[self.eigene][2])
        #print('setze_eigene', self.moegliche_genotypen, self.moegliche_blutspendergruppen, self.moegliche_plasmaspendergruppen)
        for i in self.anfang_inaktiv:
            i.config(state=NORMAL)
        self.f1e4.delete(0, END)
        self.f1e4.config(state=DISABLED)
        elter_1.set('X')
        for i, text in ((self.f1e1, self.moegliche_genotypen),
                        (self.f1e2, self.moegliche_blutspendergruppen),
                        (self.f1e3, self.moegliche_plasmaspendergruppen)):
            i.delete(0, END)
            i.insert(0, text)
        if self.eigene == 'AB':
            self.f1r8.config(state=DISABLED)
        if self.eigene == '0':
            self.f1r7.config(state=DISABLED)
        for i in self.f1canvas1.find_all():
            self.f1canvas1.delete(i)
        for i in self.f1canvas2.find_all():
            self.f1canvas2.delete(i)
        self.bild1=PhotoImage(file='daten/img/'+self.eigene+'_antigen.gif')
        self.bild2=PhotoImage(file='daten/img/'+self.eigene+'_antikoerper.gif')
        self.f1canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
        self.f1canvas2.create_image(0, 0, image=self.bild2, anchor=NW)
        self.f1canvas2.update()

    def setze_elter_1(self):
        self.eigene=str(eigene.get())
        self.elter_1=str(elter_1.get())
        self.moegliche_elter_2=str(datensammlung[self.eigene][3][self.elter_1])
        #print('setze_elter_1', self.moegliche_elter_2)
        self.f1e4.config(state=NORMAL)
        self.f1e4.delete(0, END)
        self.f1e4.insert(0, self.moegliche_elter_2)

################################################################################
root=Tk()
root.title('Blutgrupper')
#root.minsize(300, 300)
root.option_add("*Font", "Arial 12")
app=Fenster(root)
root.mainloop()
