#!/usr/bin/env python3
#-*- encoding=utf8 -*-
'''
schluessel:(Organismus,
            Merkmal 1, Allelinfos 1a, Allelinfos 1b,
            Merkmal 2, Allelinfos 2a, Allelinfos 2b),
'''

datensammlung={
# Monohybride Erbgänge
'mono_X_domrez_X':('Erbse',
                   'Blütenfarbe', 'Rot dominant A', 'Weiß rezessiv a',
                   '', '', ''),
'mono_X_intermed_X':('Wunderblume',
                     'Blütenfarbe', 'Rot kodominant R', 'Weiß kodominant W',
                     '', '', ''),
'mono_X_kodom_X':('Mensch',
                  'MN-Blutgruppensystem', 'Antigen M vorhanden kodominant M', 'Antigen N vorhanden Kodominant N',
                  '', '', ''),
# Dihybride Erbgänge
# ungekoppelt
'di_un_domrez_domrez':('Erbse',
                       'Samenfarbe', 'Gelb dominant A', 'Grün rezessiv a',
                       'Samenform', 'Rund dominant B', 'Kantig rezessiv b'),
'di_un_domrez_intermed':('Löwenmäulchen',
                         'Blütenform','Zweiseitig symmetrisch dominant A','Strahlenförmig rezessiv a',
                         'Blütenfarbe','Rot kodominant R','Weiß kodominant W'),
'di_un_domrez_kodom':('Mensch',
                      'Rhesus-Blutgruppensystem','Antigen D vorhanden dominant D','Antigen D fehlt rezessiv d',
                      'MN-Blutgruppensystem', 'Antigen M vorhanden kodominant M', 'Antigen N vorhanden Kodominant N'),
'di_un_intermed_domrez':('Löwenmäulchen',
                         'Blütenfarbe','Rot kodominant R','Weiß kodominant W',
                         'Blütenform','Zweiseitig symmetrisch dominant A','Strahlenförmig rezessiv a'),
'di_un_kodom_domrez':('Mensch',
                      'MN-Blutgruppensystem', 'Antigen M kodominant M', 'Antigen N Kodominant N',
                      'Rhesus-Blutgruppensystem','Antigen D vorhanden dominant D','Antigen D fehlt rezessiv d'),
# gekoppelt
'di_gekop_domrez_domrez':('Mais',
                          'Körnerfarbe','Dunkelbraun dominant A','Gelb rezessiv a',
                          'Körnerschrumpfung beim Trocknen','Nicht schrumpfend dominant B','Schrumpfend rezessiv b')
## alternativ als Überleitung zu Morgan:
#'di_gekop_domrez_domrez':('Taufliege',
#                          'Flügellänge','Normal dominant A','Stummel rezessiv a',
#                          'Körperfarbe','Grau dominant B', 'Schwarz rezessiv b')
}

genotypen={
# Monohybride Erbgänge
'mono_X_domrez_X_parent':'''
    AA x aa
''',
'mono_X_domrez_X_f1':'''
    |  A |  A |
----|----|----|
  a | Aa | Aa |
  a | Aa | Aa |

    Aa x Aa
''',
'mono_X_domrez_X_f2':'''
    |  A |  a |
----|----|----|
  A | AA | Aa |
  a | Aa | aa |
''',
'mono_X_intermed_X_parent':'''
    RR x WW
''',
'mono_X_intermed_X_f1':'''
    |  R |  R |
----|----|----|
  W | RW | RW |
  W | RW | RW |

    RW x RW
''',
'mono_X_intermed_X_f2':'''
    |  R |  W |
----|----|----|
  R | RR | RW |
  W | RW | WW |
''',
'mono_X_kodom_X_parent':'''
    MM x NN
''',
'mono_X_kodom_X_f1':'''
    |  M |  M |
----|----|----|
  N | MN | MN |
  N | MN | MN |

    MN x MN
''',
'mono_X_kodom_X_f2':'''
    |  M |  N |
----|----|----|
  M | MM | MN |
  N | MN | NN |
''',
# Dihybride Erbgänge
# ungekoppelt
'di_un_domrez_domrez_parent':'''
    AABB x aabb
''',
'di_un_domrez_domrez_f1':'''
     |   AB |   AB |
-----|------|------|
  ab | AaBb | AaBb |
  ab | AaBb | AaBb |

    AaBb x AaBb
''',
'di_un_domrez_domrez_f2':'''
     |   AB |   Ab |   aB |   ab |
-----|------|------|------|------|
  AB | AABB | AABb | AaBB | AaBb |
  Ab | AABb | AAbb | AaBb | Aabb |
  aB | AaBB | AaBb | aaBB | aaBb |
  ab | AaBb | Aabb | aaBb | aabb |
''',
'di_un_domrez_intermed_parent':'''
    AARR x aaWW
''',
'di_un_domrez_intermed_f1':'''
     |   AR |   AR |
-----|------|------|
  aW | AaRW | AaRW |
  aW | AaRW | AaRW |

    AaRW x AaRW
''',
'di_un_domrez_intermed_f2':'''
     |   AR |   AW |   aR |   aW |
-----|------|------|------|------|
  AR | AARR | AARW | AaRR | AaRW |
  AW | AARW | AAWW | AaRW | AaWW |
  aR | AaRR | AaRW | aaRR | aaRW |
  aW | AaRW | AaWW | aaRW | aaWW |
''',
'di_un_intermed_domrez_parent':'''
    AARR x aaWW
''',
'di_un_intermed_domrez_f1':'''
     |   AR |   AR |
-----|------|------|
  aW | AaRW | AaRW |
  aW | AaRW | AaRW |

    AaRW x AaRW
''',
'di_un_intermed_domrez_f2':'''
     |   AR |   AW |   aR |   aW |
-----|------|------|------|------|
  AR | AARR | AARW | AaRR | AaRW |
  AW | AARW | AAWW | AaRW | AaWW |
  aR | AaRR | AaRW | aaRR | aaRW |
  aW | AaRW | AaWW | aaRW | aaWW |
''',
'di_un_domrez_kodom_parent':'''
    DDMM x ddNN
''',
'di_un_domrez_kodom_f1':'''
     |   DM |   DM |
-----|------|------|
  dN | DdMN | DdMN |
  dN | DdMN | DdMN |

    DdMN x DdMN
''',
'di_un_domrez_kodom_f2':'''
     |   DM |   DN |   dM |   dN |
-----|------|------|------|------|
  DM | DDMM | DDMN | DdMM | DdMN |
  DN | DDMN | DDNN | DdMN | DdNN |
  dM | DdMM | DdMN | ddMM | ddMN |
  dN | DdMN | DdNN | ddMN | ddNN |
''',
'di_un_kodom_domrez_parent':'''
    DDMM x ddNN
''',
'di_un_kodom_domrez_f1':'''
     |   DM |   DM |
-----|------|------|
  dN | DdMN | DdMN |
  dN | DdMN | DdMN |

    DdMN x DdMN
''',
'di_un_kodom_domrez_f2':'''
     |   DM |   DN |   dM |   dN |
-----|------|------|------|------|
  DM | DDMM | DDMN | DdMM | DdMN |
  DN | DDMN | DDNN | DdMN | DdNN |
  dM | DdMM | DdMN | ddMM | ddMN |
  dN | DdMN | DdNN | ddMN | ddNN |
''',
# gekoppelt
'di_gekop_domrez_domrez_parent':'''
    AABB x aabb
''',
'di_gekop_domrez_domrez_f1':'''
     |   AB |   AB |
-----|------|------|
  ab | AaBb | AaBb |
  ab | AaBb | AaBb |

    AaBb x AaBb
''',
'di_gekop_domrez_domrez_f2':'''
     |   AB |   ## |   ## |   ab |
-----|------|------|------|------|
  AB | AABB | #### | #### | AaBb |
  ## | #### | #### | #### | #### |
  ## | #### | #### | #### | #### |
  ab | AaBb | #### | #### | aabb |

     |   AB |   ab |
-----|------|------|
  AB | AABB | AaBb |
  ab | AaBb | aabb |
''',









}
