#!/usr/bin/env python3
#-*- encoding=utf8 -*-
import os
from tkinter import *
from tkinter import font
# Textdatei
import sys
sys.path.insert(0, 'daten')
from textdaten import datensammlung, genotypen
import webbrowser

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame, pady=4, padx=2)
        self.frame2=Frame(frame, pady=4, padx=2)
        self.frame3=Frame(frame, pady=4, padx=2)
        self.frame4=Frame(frame, pady=4, padx=2)
        self.frame5=Frame(frame, pady=4, padx=2)
        for f, row, column, columnspan, sticky in (
                (frame,       0, 0, 1, E+W),
                (self.frame1, 0, 0, 2, E+W),
                (self.frame2, 1, 0, 1, E+W),
                (self.frame3, 1, 1, 1, E+W),
                (self.frame4, 2, 0, 2, E+W),
                (self.frame5, 3, 0, 2, E+W),
                ):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        # Rahmen 1: Auswahl des Erbgangtyps
        self.f1l1=Label(self.frame1, text='Anzahl der betrachteten Merkmale:', anchor=E)
        global merkmalsanzahl
        merkmalsanzahl=StringVar()
        merkmalsanzahl.set('X')
        self.f1r1=Radiobutton(self.frame1, text='Monohybrid', variable=merkmalsanzahl, value='mono', command=self.setze_merkmalsanzahl, anchor=W)
        self.f1r2=Radiobutton(self.frame1, text='Dihybrid', variable=merkmalsanzahl, value='di', command=self.setze_merkmalsanzahl, anchor=W)
        global allelkopplung
        allelkopplung=StringVar()
        allelkopplung.set('X')
        self.f1r3=Radiobutton(self.frame1, text='Ungekoppelt', variable=allelkopplung, value='un', command=self.setze_allelkopplung, anchor=W)
        self.f1r4=Radiobutton(self.frame1, text='Gekoppelt', variable=allelkopplung, value='gekop', command=self.setze_allelkopplung, anchor=W)
        self.f1l2=Label(self.frame1, text='Merkmal 1:', anchor=E)
        global mtyp01
        mtyp01=StringVar()
        mtyp01.set('X')
        self.f1r5=Radiobutton(self.frame1, text='Dominant/rezessiv', variable=mtyp01, value='domrez', command=self.setze_merkmalstyp01, anchor=W)
        self.f1r6=Radiobutton(self.frame1, text='Intermediär', variable=mtyp01, value='intermed', command=self.setze_merkmalstyp01, anchor=W)
        self.f1r7=Radiobutton(self.frame1, text='Kodominant', variable=mtyp01, value='kodom', command=self.setze_merkmalstyp01, anchor=W)
        self.f1l3=Label(self.frame1, text='Merkmal 2:', anchor=E)
        global mtyp02
        mtyp02=StringVar()
        mtyp02.set('X')
        self.f1r8=Radiobutton(self.frame1,  text='Dominant/rezessiv', variable=mtyp02, value='domrez', command=self.setze_merkmalstyp02, anchor=W)
        self.f1r9=Radiobutton(self.frame1,  text='Intermediär', variable=mtyp02, value='intermed', command=self.setze_merkmalstyp02, anchor=W)
        self.f1r10=Radiobutton(self.frame1, text='Kodominant', variable=mtyp02, value='kodom', command=self.setze_merkmalstyp02, anchor=W)

        # Rahmen 2: Navigation Generationen
        global generation
        generation=StringVar()
        generation.set('X')
        self.f2r1=Radiobutton(self.frame2, text='Parentalgeneration', variable=generation, value='parent', command=self.setze_generation, anchor=W)
        self.f2r2=Radiobutton(self.frame2, text='1. Filialgeneration', variable=generation, value='f1', command=self.setze_generation, anchor=W)
        self.f2r3=Radiobutton(self.frame2, text='2. Filialgeneration', variable=generation, value='f2', command=self.setze_generation, anchor=W)
        self.f2l1=Label(self.frame2, text=30*'-')
        global ebene
        ebene=StringVar()
        ebene.set('X')
        self.f2r4=Radiobutton(self.frame2, text='Phänotyp', variable=ebene, value='phaen', command=self.setze_generation, anchor=W)
        self.f2r5=Radiobutton(self.frame2, text='Genotyp',  variable=ebene, value='genotyp', command=self.setze_generation, anchor=W)

        # Rahmen 3: Ausgabe
        self.f3canvas1=Canvas(self.frame3, width=580, height=450, bg='white')
        self.bild1=PhotoImage(file='daten/img/start.gif')
        self.f3canvas1.create_image(0, 0, image=self.bild1, anchor=NW)

        # Rahmen 4: Legende
        self.f4l1=Label(self.frame4, text='Organismus:', anchor=E)
        self.f4e1=Entry(self.frame4, width=30, bg='white', disabledforeground='black')
        self.f4l2=Label(self.frame4, text='Merkmal 1:', anchor=E)
        self.f4e2=Entry(self.frame4, width=30, bg='white', disabledforeground='black')
        self.f4l3=Label(self.frame4, text='Merkmalsausprägung, Durchsetzungskraft und Allelsymbol:')
        self.f4e3=Entry(self.frame4, width=30, bg='white', disabledforeground='black')
        self.f4e4=Entry(self.frame4, width=30, bg='white', disabledforeground='black')
        self.f4l4=Label(self.frame4, text='Merkmal 2:', anchor=E)
        self.f4e5=Entry(self.frame4, width=30, bg='white', disabledforeground='black')
        self.f4e6=Entry(self.frame4, width=30, bg='white', disabledforeground='black')
        self.f4e7=Entry(self.frame4, width=30, bg='white', disabledforeground='black')

        # Rahmen 5: Navigation
        icon_reset = PhotoImage(file='daten/icons/view-refresh.gif')
        self.f5b1=Button(self.frame5, 
                         text='Zurücksetzen', 
                         command=self.zurueck_setzen,
                         image=icon_reset,
                         compound=LEFT)
        self.f5b1.icon_reset=icon_reset
        icon_exit = PhotoImage(file='daten/icons/dialog-close.gif')
        self.f5b2=Button(self.frame5, 
                         text='Beenden', 
                         command=root.destroy,
                         image=icon_exit,
                         compound=LEFT)
        self.f5b2.icon_exit=icon_exit

        # Fensterelemente setzen
        for i, row, column, rowspan, columnspan, sticky in (
                # Rahmen 1
                (self.f1l1, 0, 0, 1, 1, E+W), (self.f1r1, 0, 1, 1, 1, E+W), (self.f1r2, 0, 2, 1, 2, E+W),
                                                                            (self.f1r3, 1, 2, 1, 1, E+W), (self.f1r4,  1, 3, 1, 1, E+W),
                (self.f1l2, 2, 0, 1, 1, E+W), (self.f1r5, 2, 1, 1, 1, E+W), (self.f1r6, 2, 2, 1, 1, E+W), (self.f1r7,  2, 3, 1, 1, E+W),
                (self.f1l3, 3, 0, 1, 1, E+W), (self.f1r8, 3, 1, 1, 1, E+W), (self.f1r9, 3, 2, 1, 1, E+W), (self.f1r10, 3, 3, 1, 1, E+W),
                # Rahmen 2
                (self.f2r1, 0, 0, 1, 1, E+W),
                (self.f2r2, 1, 0, 1, 1, E+W),
                (self.f2r3, 2, 0, 1, 1, E+W),
                (self.f2l1, 3, 0, 1, 1, E+W),
                (self.f2r4, 4, 0, 1, 1, E+W),
                (self.f2r5, 5, 0, 1, 1, E+W),
                # Rahmen 3
                (self.f3canvas1, 0, 0, 1, 1, E+W),
                # Rahmen 4
                (self.f4l1, 0, 0, 1, 1, E+W), (self.f4e1, 0, 1, 1, 1, E+W),      (self.f4l3, 0, 4, 1, 2, E+W),
                (self.f4l2, 1, 0, 1, 1, E+W), (self.f4e2, 1, 1, 1, 1, E+W),      (self.f4e3, 1, 4, 1, 1, E+W), (self.f4e4, 1, 5, 1, 1, E+W),
                (self.f4l4, 2, 0, 1, 1, E+W), (self.f4e5, 2, 1, 1, 1, E+W),      (self.f4e6, 2, 4, 1, 1, E+W), (self.f4e7, 2, 5, 1, 1, E+W),
                # Rahmen 5
                (self.f5b1, 0, 0, 1, 1, E+W), (self.f5b2, 0, 1, 1, 1, E+W)
                ):
            i.grid(row=row, column=column, rowspan=rowspan, columnspan=columnspan, sticky=sticky)

        self.aktiv_ausgangszustand=(
            self.f1l1, self.f1r1, self.f1r2
        )
        self.inaktiv_ausgangszustand=(
                                  self.f1r3, self.f1r4, 
            self.f1l2, self.f1r5, self.f1r6, self.f1r7,
            self.f1l3, self.f1r8, self.f1r9, self.f1r10,
            self.f2r1, 
            self.f2r2, 
            self.f2r3,
            self.f2l1,
            self.f2r4,
            self.f2r5,
            self.f4l1, self.f4e1, 
            self.f4l2, self.f4e2, self.f4l3, self.f4e3, self.f4e4,
            self.f4l4, self.f4e5,            self.f4e6, self.f4e7
        )
        self.aktiv_monohybrid=(
            self.f1l2, self.f1r5, self.f1r6, self.f1r7
        )
        self.aktiv_dihybrid=(
            self.f1r3, self.f1r4, 
            self.f1l2, self.f1r5, self.f1r6, self.f1r7,
            self.f1l3, self.f1r8, self.f1r9, self.f1r10
        )
        for i in self.inaktiv_ausgangszustand:
            i.config(state=DISABLED)

        ## Funktionen  #########################################################

    def zurueck_setzen(self):
        for i in (self.f4e1, 
                  self.f4e2, self.f4e3, self.f4e4,
                  self.f4e5, self.f4e6, self.f4e7):
            i.config(state=NORMAL)
            i.delete(0, END)
            i.config(disabledbackground='lightgrey')
        for i in self.aktiv_ausgangszustand:
            i.config(state=NORMAL)
        merkmalsanzahl.set('X')
        for i in self.inaktiv_ausgangszustand:
            i.config(state=DISABLED)
        allelkopplung.set('X')
        mtyp01.set('X')
        mtyp02.set('X')
        generation.set('X')
        ebene.set('X')
        for i in self.f3canvas1.find_all():
            self.f3canvas1.delete(i)
        self.bild1=PhotoImage(file='daten/img/start.gif')
        self.f3canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
        self.f3canvas1.update()
        #print('zurueck_setzen')

    def setze_merkmalsanzahl(self):
        self.merkmalsanzahl=str(merkmalsanzahl.get())
        if self.merkmalsanzahl == 'mono':
            for i in self.aktiv_monohybrid:
                i.config(state=NORMAL)
            #for i in (self.f4e5, self.f4e6, self.f4e7):
            #    i.config(disabledbackground='white')
        elif self.merkmalsanzahl == 'di':
            for i in (self.f1r3, self.f1r4):
                i.config(state=NORMAL)
            #allelkopplung.set('un')
        for i in (self.f1r1, self.f1r2):
            i.config(state=DISABLED)
        #print('setze_merkmalsanzahl', self.merkmalsanzahl)

    def setze_allelkopplung(self):
        self.allelkopplung=str(allelkopplung.get())
        for i in self.aktiv_dihybrid:
                i.config(state=NORMAL)
        if self.allelkopplung == 'gekop':
            for i in (self.f1r6, self.f1r7,
                      self.f1r9, self.f1r10):
                i.config(state=DISABLED)
        for i in (self.f1r3, self.f1r4):
                i.config(state=DISABLED)
        #print('setze_allelkopplung')

    def setze_merkmalstyp01(self):
        self.merkmalsanzahl=str(merkmalsanzahl.get())
        self.mtyp01=str(mtyp01.get())
        self.mtyp02=str(mtyp02.get())
        if self.merkmalsanzahl == 'mono':
            for i in (self.f2r1, 
                      self.f2r2, 
                      self.f2r3,
                      self.f2r4,
                      self.f2r5,
                      self.f4l1, self.f4e1, 
                      self.f4l2, self.f4e2, self.f4l3, self.f4e3, self.f4e4):
                i.config(state=NORMAL)
            for i in (self.f1r5, self.f1r6, self.f1r7):
                i.config(state=DISABLED)
            self.hole_erbgangsdaten()
        elif self.merkmalsanzahl == 'di' and self.mtyp02 != 'X':
            for i in (self.f2r1, 
                      self.f2r2, 
                      self.f2r3,
                      self.f2r4,
                      self.f2r5,
                      self.f4l1, self.f4e1, 
                      self.f4l2, self.f4e2, self.f4l3, self.f4e3, self.f4e4,
                      self.f4l4, self.f4e5):
                i.config(state=NORMAL)
            self.hole_erbgangsdaten()
        if self.mtyp01 == 'intermed' or self.mtyp01 == 'kodom':
            for i in (self.f1r9, self.f1r10):
                i.config(state=DISABLED)
        for i in (self.f1r5, self.f1r6, self.f1r7):
            i.config(state=DISABLED)
        #print('setze_merkmalstyp01', self.mtyp01)

    def setze_merkmalstyp02(self):
        self.merkmalsanzahl=str(merkmalsanzahl.get())
        self.mtyp01=str(mtyp01.get())
        self.mtyp02=str(mtyp02.get())
        if self.merkmalsanzahl == 'di' and self.mtyp01 != 'X':
            for i in (self.f2r1, 
                      self.f2r2, 
                      self.f2r3,
                      self.f2r4,
                      self.f2r5,
                      self.f4l1, self.f4e1, 
                      self.f4l2, self.f4e2, self.f4l3, self.f4e3, self.f4e4,
                      self.f4l4, self.f4e5):
                i.config(state=NORMAL)
            self.hole_erbgangsdaten()
        if self.mtyp02 == 'intermed' or self.mtyp02 == 'kodom':
            for i in (self.f1r6, self.f1r7):
                i.config(state=DISABLED)
        for i in (self.f1r8, self.f1r9, self.f1r10):
            i.config(state=DISABLED)
        #print('setze_merkmalstyp02', self.mtyp01, self.mtyp02)

    def hole_erbgangsdaten(self):
        self.merkmalsanzahl=str(merkmalsanzahl.get())
        self.allelkopplung=str(allelkopplung.get())
        self.mtyp01=str(mtyp01.get())
        self.mtyp02=str(mtyp02.get())
        self.schluessel=str(self.merkmalsanzahl+'_'+self.allelkopplung+'_'+self.mtyp01+'_'+self.mtyp02)
        if self.merkmalsanzahl == 'mono':
            for i in (self.f4e1, 
                      self.f4e2, self.f4e3, self.f4e4):
                i.config(disabledbackground='white')
        elif self.merkmalsanzahl == 'di':
            for i in (self.f4e1, 
                      self.f4e2, self.f4e3, self.f4e4,
                      self.f4e5, self.f4e6, self.f4e7):
                i.config(disabledbackground='white')
        self.organismus=datensammlung[self.schluessel][0]
        self.merkmal_1=datensammlung[self.schluessel][1]
        self.merkmal_1_allel_1=datensammlung[self.schluessel][2]
        self.merkmal_1_allel_2=datensammlung[self.schluessel][3]
        self.merkmal_2=datensammlung[self.schluessel][4]
        self.merkmal_2_allel_1=datensammlung[self.schluessel][5]
        self.merkmal_2_allel_2=datensammlung[self.schluessel][6]
        for i, text in (
                (self.f4e1, self.organismus), 
                (self.f4e2, self.merkmal_1), (self.f4e3, self.merkmal_1_allel_1), (self.f4e4, self.merkmal_1_allel_2),
                (self.f4e5, self.merkmal_2), (self.f4e6, self.merkmal_2_allel_1), (self.f4e7, self.merkmal_2_allel_2)):
            i.config(state=NORMAL)
            i.delete(0, END)
            i.insert(0, text)
            i.config(state=DISABLED)
        #print('hole_ergbangsdaten', self.schluessel)
        for i in (self.f2r4, self.f2r5):
            i.config(state=NORMAL)
        generation.set('parent')
        ebene.set('phaen')
        self.setze_generation()

    def setze_generation(self):
        self.merkmalsanzahl=str(merkmalsanzahl.get())
        self.allelkopplung=str(allelkopplung.get())
        self.mtyp01=str(mtyp01.get())
        self.mtyp02=str(mtyp02.get())
        self.generation=str(generation.get())
        self.ebene=str(ebene.get())
        self.bildpfad=str('daten/img/'+self.merkmalsanzahl+'_'+self.allelkopplung+'_'+self.mtyp01+'_'+self.mtyp02+'_'+self.generation+'_'+self.ebene+'.gif')
        print(self.bildpfad)
        # Abbbildung anzeigen
        for i in self.f3canvas1.find_all():
            self.f3canvas1.delete(i)
        if self.ebene == 'phaen':
            self.bild1=PhotoImage(file=self.bildpfad)
            self.f3canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
        elif self.ebene == 'genotyp':
            self.genotypenschluessel=str(self.merkmalsanzahl+'_'+self.allelkopplung+'_'+self.mtyp01+'_'+self.mtyp02+'_'+self.generation)
            self.genotypentext=genotypen[self.genotypenschluessel]
            self.f3canvas1.create_text(50,
                                       50,
                                       text=self.genotypentext,
                                       fill='black',
                                       font=('courier', 16, 'bold'),
                                       anchor=NW,
                                       justify=LEFT)
        self.f3canvas1.update()

################################################################################
root=Tk()
root.title('Mendler')
root.minsize(300, 300)
app=Fenster(root)
root.mainloop()
