#!/usr/bin/env python3
#-*- encoding=utf8 -*-

texte={
'neuro_muskulaer':'''
Die Nervenzelle gliedert sich in das "Soma" (den eigentlichen Zellkörper), die "Dendriten" (mehrere baumartige Fortsätze) sowie das "Axon" (einen sehr langen und dünnen Ausläufer). \n\tAm Anfang des Axons liegt der "Axonhügel", der v.a. bei der Erregungsverrechnung eine Rolle spielt.\n\tAm Ende des Axons befindet sich der "Axonendknoten" (eine Verdickung zur Oberflächenvergrößerung).\n\tDer Axonendknoten bildet zusammen mit dem Zellmembranausschnitt der nachfolgenden Zelle eine "Synapse" (Verknüpfungsstelle zwischen einer Nervenzelle und einer nachfolgenden Zelle).\n\tBei einem efferenten Motoneuron verzweigt sich das Axon zur Oberflächenvergrößerung in mehrere Endverzweigungen, deren Axonendknoten jeweils eine "Motorische Endplatte" mit der nachfolgenden Muskelzelle bilden. \n\tAls Neurotransmitter dient Acetylcholin.
Hier ist ein "markhaltiges" Axon mit einer "Myelinscheide" aus "Schwannschen Zellen" dargestellt. \n\tDie nicht umhüllten Axonabschnitte bezeichnet man als "Ranviersche Schnürringe". In diesen Bereichen findet die Erregungsleitung statt.
''',
'neuro_neuronal':'''
Bei einem Interneuron ist das Axon häufig stark verzweigt.
Bei einem afferenten sensorischen Neuron liegt das Soma häufig mitten am Axon, die Dendriten entspringen dann einem Ende des Axons.

''',
'neuro_sekretorisch':'''
Efferente neuro-sekretorische Neurone bilden die Schnittstelle zum Hormonsystem, zum Immunsystem sowie zum Verdauungssystem.
''',
'kanalproteine':'''
Alle Kanalproteine erlauben den passiven Transport (also durch Diffusion) von Ionen entlang eines Konzentrationsgefälles. Sie unterscheiden sich bezüglich ihres Öffnungsmechanismus sowie des jeweils selektiv durchgelassenen Ionentyps.\n\tKaliumionen-Sickerkanäle sind ständig geöffnet. Sie spielen eine wichtige Rolle bei der Entstehung des Ruhepotenzials.\n\tSpannungsabhängige Natriumionen-Kanäle sind nur kurzzeitig aufgrund einer Spannungsänderung geöffnet. Sie spielen eine wichtige Rolle in der Depolarisationsphase des Aktionspotenzials.\n\tSpannungsabhängige Kaliumionen-Kanäle sind nur kurzzeitig aufgrund einer Spannungsänderung geöffnet. Sie spielen eine wichtige Rolle in der Re- und Hyperpolarisationsphase des Aktionspotenzials.
''',
'carrierproteine':'''
Das Carrierprotein "Natrium-Kalium-Pumpe" transportiert unter Energieverbrauch (in Form von ATP) zwei verschiedene Ionensorten in entgegengesetzte Richtungen entgegen eines Konzentrationsgefälles. Es erfüllt seine Arbeit durch eine Änderung seines räumlichen Baus. \n\tDie Natrium-Kalium-Pumpe spielt eine wichtige Rolle bei der Aufrechterhaltung des Ruhepotenzials sowie bei der Refraktärphase des Aktionspotenzials.
''',
'diffusion':'''
Die Diffusion ist ein Vorgang, der zu einer möglichst gleichmäßigen Verteilung von Teilchen führt, etwa in Gasen oder in Lösungen.\n\tBefindet sich in einer Hälfte eines durch eine Trennwand geteilten Gefäßes eine Kaliumchlorid-Lösung und in der anderen Hälfte reines Wasser, so wird sich nach dem Entfernen der Trennwand aufgrund der thermischen Eigenbewegung der gelösten Ionen nach einiger Zeit auch ohne Konvektion ("Umrühren") eine  gleichmäßig verteilte Kaliumchlorid-Lösung mit genau der halben Konzentration einstellen.\n\tDie Triebkraft liegt hier v.a. in der Entropiezunahme.
''',
'osmose':'''
Benutzt man an Stelle einer absolut undurchlässigen Trennwand eine "semipermeable" Membran (die nur für eine Teilchensorte, nämlich Wasserteilchen) durchlässig ist, so wird vermehrt Wasser durch diese semipermeable Membran auf die Seite der höher konzentrierten Kaliumchlorid-Lösung diffundieren, um diese gewissermaßen zu "verdünnen". \n\tDabei erhöht sich auf der Seite der höher konzentrierten Lösung der Druck, so dass hier im Modellversuch der Wasserspiegel ansteigt. \n\tWäre wie in einer von einer dicken Zellwand umhüllten Pflanzenzelle keine Volumenvergrößerung möglich, so entstünde der sogenannte "Turgodruck", welcher zur Stabilität von Gefäßpflanzen beiträgt.
''',
'selektiv_permeable_membran':'''
In der Modellabbildung befindet sich in der linken Kammer Kaliumchlorid-Lösung, in der rechten Kammer Natriumchlorid-Lösung. Die Kaliumionen sind hier entgegen des zu erwartenden Ionenradius kleiner dargestellt, da sie eine kleinere Hydrathülle besitzen. Sie können daher bereits die kleinen Poren der selektiv permeablen Membran passieren.\n\tIn einer Nervenzelle (die nur von einer sehr dünnen Membran umhüllt ist!), muss das osmotische Potenzial der Innen- und der Außenseite immer gleich sein. Im Modellversuch darf sich der Wasserspiegel also nicht verändern. Die linke Kammer des Modeellaufbaus entspricht dem Zellinneren. Das osmotische Potenzial wird  im Zellinneren über Anonische Protein-Seitenketten (an Stelle der Chloridionen) geregelt.\n\tWenn die selektiv permeable Membran ausschließlich für Kaliumionen durchlässig ist (alle biologischen Membranen sind darüberhinaus Wasser durchlässig), so wird ein Teil der Kaliumionen ins Zellinnere diffundieren, bis sich ein dynamisches Gleichgewicht zwischen dem Konzentrationsgefälle und der entstehenden Spannungsdifferenz (das Zelläußere besitzt positiven Ladungsüberschuss, das Zellinnere negativen) einstellt.
''',
'umgebung_der_urzelle':'''
Da Natriumchlorid (Kochsalz) sehr gut wasserlöslich ist, enthält Meerwasser große Mengen an Natriumionen und Chloridionen.\n\tDie Kaliumionenkonzentration sowie die Calciumionenkonzentration ist aufgrund der schlechteren Löslichkeit der entsprechenden Salze (z.B. Calciumcarbonat) viel geringer.\n\tIn vielzelligen Organismen setzt sich die Zwischenzellflüssigkeit (z.B. Lymphe) prinzipiell genauso zusammen.\n\tIm Zellinneren wird unter hohem Energieverbrauch mit Hilfe der Natrium-Kalium-Pumpe eine etwas höhere Kaliumionenkonzentration erreicht.\nEs können also grundsätzlich die folgenden Konzentrationsgefälle genutzt werden:\n- Natriumionen (außen erhöht, Depolarisation der Axonmembran und der postsynaptischen Membran)\n- Kaliumionen (innen erhöht, Entstehung des Ruhepotenzials, Re- und Hyperpolarisation)\n- Calciumionen (außen erhöht, Start der chemischen Erregungsübetragung am Axonendknoten, Muskelzellen-Kontraktion)\n- Chloridionen (außen erhöht, Hyperpolarisation an hemmenden/inhibitorischen Synapsen)
''',
'entstehung':'''
Kaliumionen diffundieren durch die ständig geöffneten Kaliumionen-Sickerkanäle nach außen. Es entsteht eine konstante Spannungsdifferenz zwischen außen (positiv) und innen (negativ) von -70 Millivolt.
''',
'leckstroeme':'''
Da sich ein paar wenige der spannungsabhängigen Natriumionenkanäle auch ohne Spannungsänderung spontan öffnen, diffundieren ständig auch Natriumionen ins Zellinnere. Dadurch würde sich das Ruhepotenzial eigentlich wieder auf Werte größer als -70 Millivolt in Richtung 0 Millivolt abbauen.
''',
'aufrechterhaltung':'''
Damit das Ruhepotenzial seinen (ohne äußere Störung durch eine ankommende Spannungsänderung und ohne eine dadurch ausgelöste Öffnung der anderen Kanalproteintypen) konstanten Wert von -70 Millivolt beibehält, muss die Natrium-Kalium-Pumpe ständig unter ATP-Verbrauch Natriumionen wieder zurück nach außen und Kaliumionen wieder zurück nach innen befördern, es handelt sich also um einen "Antiport".
Da bei einer Konformationsänderung 3 Natriumionen nach außen aber nur 2 Kaliumionen wieder nach innen befördert werden, erfolgt der Transport nicht nur entgegen des Konzentrationsgefälles, sondern zusätzlich noch entgegen des Spannungsgefälles.
''',
'depolarisation':'''
Das Aktionspotenzial ist nicht wie das Ruhepotenzial eine konstante Spannungsdifferenz, sondern eine typische Veränderung der Spannungsdifferenz, d.h. es beschreibt einen Spannungsdifferenz-Verlauf mit verschiedenen Phasen.\n\tVoraussetzung ist eine überschwellige Depolarisation durch ein ankommendes Aktionspotenzial (oder eine künstliche "Reizung" mit einer Elektrode) aus der unmittelbaren Nachbarschaft des betrachteten Axonmembranabschnitts.\n\tIm Falle einer zu schwachen, unterschwelligen Depolarisation werden nicht genügend spannungsabhängige Natriumionenkanäle geöffnet, es bildet sich kein Aktionspotenzial aus.\n\tIm Falle einer überschwelligen Depolarisation entsteht ein Aktionspotenzial, das immer gleich abläuft, sowohl bezüglich seiner Phasen als auch der durchlaufenen Spannungswerte.\nDie spannungsabhängigen Natriumionenkanäle öffnen sich sehr schnell und Natriumionen strömen entlang des Konzentrationsgefälles ins Zellinnere ein, bis sogar eine Ladungsumkehr (außen negativ, innen positiv) stattfindet.\n\tEs findet eine positive Rückkopplung ("Aufschaukelungsprozess") statt zwischen der Depolarisation und der Öffnung weiterer spannungsabhängiger Natriumionenkanäle.
''',
're_und_hyperpolarisation':'''
Die spannungsabhängigen Natriumionenkanäle schließen sich wieder und die spannungsabhängigen Kaliumionenkanäle öffnen sich. Es strömen entlang des Konzentrationsgefälles Kaliumionen ins Zelläußere bis sich die Ladung erneut umkehrt (Repolarisation). Zwischenzeitlich wird sogar eine Spannungsdifferenz von etwa -90 Millivolt durchlaufen, die sogar unterhalb des normalen Ruhepotenzial liegt (Hyperpolarisation).\nNach kurzer Zeit schließen sich auch die spannungsabhängigen Kaliumionenkanäle wieder.
''',
'refraktaerphase':'''
Sowohl die spannungsabhängigen Natriumionenkanäle als auch die spannungsabhängigen Kaliumionenkanäle können eine Zeitlang nicht geöffnet werden. Das Schwellenpotenzial ist in dieser Zeit so hoch, dass es selbst bei einer weiteren ankommenden Depolarisation (bzw. einer erneuten Reizung des benachbarten Axonmembranabschnitts) nicht zu einer überschwelligen Depolarisation kommen kann.\n\tDie Natrium-Kalium-Pumpe transportiert wieder ähnlich wie bei der Aufrechterhaltung des Ruhepotenzials die aufgenommenen Natriumionen zurück nach außen, die abgegebenen Kaliumionen zurück nach innen.\nDa alle Aktionspotenziale die gleiche Form besitzen, wirken sie "Frequenz moduliert", d.h. ein möglichst schnelles Aufeinanderfolgen (nicht aber eine abweichende Amplitude!) bewirkt z.B. eine stärkere Muskelkontraktion. 
''',
't1':'''
An dem näher am Axonhügel liegenden ersten Axonmembranabschnitt (links) hat sich ein Aktionspotenzial gebildet, dessen Depolarisationsphase gerade den höchsten Punkt der Ladungsumkehr erreicht hat. Dies bewirkt an dem in Richtung Synapse folgenden zweiten Axonmembranabschnitt eine beginnende Depolarisation.\n\tDie im Axoninneren erfolgenden Ringströme sind für die Verringerung der Geschwindigkeit der Erregungsleitung an marklosen Nervenfasern bei kleinerem Axondurchmesser verantwortlich.\n\tAm dritten Axonmembranabschnitt in Richtung Synapse befindet sich derzeit ein Ruhepotenzial.
''',
't2':'''
An dem ersten Axonmembranabschnitt liegt noch die Refraktärphase des vorangegangenen Aktionspotenzials vor, in diese Richtung kann der am zweiten Axonmembranabschnitt gerade erreichte höchste Punkt der Ladungsumkehr also keine Depolarisation hervorrufen, wohl aber in dem dritten in Richtung Synapse folgenden dritten Axonmembranabschnitt, an dem dadurch eine Depolarisation ausgelöst wird.\n\tAufgrund der Refraktärphase findet die Erregungsleitung nur in eine Richtung (zur Synapse hin) statt.
''',
't3':'''
An dem ersten Axonmembranabschnitt liegt wieder ein gewöhnliches Ruhepotenzial vor. Im Falle einer erneuten vom Axonhügel ausgehenden Depolarisation könnte also ein neues Aktionspotenzial ausgelöst werden.\nDer zweite Axonmembranabschnitt befindet sich in der Refraktärphase, eine Depolarisation ist hier also gerade nicht möglich.\nDer dritte Axonmembranabschnitt erreicht gerade den höchsten Punkt der Ladungsumkehr am Ende der Depolarisationsphase. Von hier aus wird entweder ein weiterer Axonmembranabschnitt depolarisiert oder aber am Axonendknoten die spannungsabhängigen Calciumionenkanäle geöffnet.\nDie hier dargestellte "saltatorische" Erregungsleitung an einer markhaltigen Nervenfaser ist viel schneller als die Erregungsleitung an marklosen Nervenfasern, da die mittlere Leitungsgeschwindigkeit an den Schnürringen bzw. an der nicht myeliniserten Axonmembran sehr langsam ist, im Bereich der "übersprungenen" Schwannschen Zellen jedoch sehr hoch ist.
''',
'neuromuskulaere_synapse':'''
Der Axonendknoten ist einerseits abgeflacht, damit eine möglichst große der postsynaptsichen Membran gegenüberliegenden präsynaptische Membranfläche resultiert, andererseits aber auch kugelig, um möglichst viele Neurotransmitter gefüllte Vesikel sowie ein dichtes Netz an Gerüstproteinen für eine schnelle Exocytose darin unterzubringen.\n\tIm Übergangsbereich von der Axonmembran zur präsynaptischen Membran liegen spannungsabhängige Calciumionenkanäle.\nDer synaptische Spalt muss möglichst schmal sein, da hier Neurotransmitter hindurch diffundieren müssen und diese chemische Form der Erregungsübetragung um ein Vielfaches langsamer ist als die elektrische Erregungsleitung am Axon. In der postsynaptischen Membran der Muskelzelle liegen transmitterabhängige Natriumionenkanäle mit bestimmten Andockstellen ("Rezeptoren"), die genau zu dem hier verwendeten Neurotransmitter Acetylcholin passen.\n\tIn enger Nachbarschaft zur Synapse liegen auf der Muskelzellmenbram auch spannungsabhängige Natriumionenkanäle (genau wie in der Axonmembran).
''',
'neuroneuronale_synapse':'''
Hier ist eine glutaminerge Synapse des Rückenmarks skizziert, die einen Opioid-Rezeptor an der präsynaptsichen Membran besitzt. Im Falle der Anwesenheit eines "Neuromudulators" wie Endorphinen, Morphin oder Conotoxin kann so zur Schmerzbekämpfung die Öffnung der spannungsabhängigen Calciumionenkanäle trotz ankommendem Aktionspotenzial verhindert werden.\nWeitere Neurotransmitter neben Glutamin sind (Nor-)Adrenalin, Dopamin und Serotonin.\n\tNeben erregenden Synapsen (fördern die postsynaptische Depolarisation durch Natriumionen-Einstrom) gibt es auch hemmende Synapsen (behindern die postsynaptische Depolarisation durch Chloridionen-Einstrom).
''',
'1':'''
Ankommende Aktionspotenziale öffnen die spannungsabhängigen Calciumionenkanäle.\nCalciumionen strömen entlang des Konzentrationsgefälles ins Zellinnere ein.
''',
'2':'''
Die Calciumionen lösen eine Exocytose des Neurotransmitters aus Vesikeln in den synaptischen Spalt aus.\nIm synaptischen Spalt diffundiert der Neurotransmitter zur postsynaptischen Membran.
''',
'3':'''
Der Neurotransmitter bindet sich an die Rezeptorstellen der transmitterabhängigen Natriumionenkanäle und öffnet diese.
''',
'4':'''
Natriumionen strömen entlang des Konzentrationsgefälles durch die geöffneten transmitterabhängigen Natriumionenkanäle ins Innere der Muskelzelle ein. Es entsteht zunächst auch bei unterschwelliger Depolarisation ein Amplituden moduliertes Endplattenpotenzial (= postsynaptisches Potenzial).\n\tBei einer neuro-neuronalen Synapse werden diese postsynaptischen Potenziale am Axonhügel verrechnet (räumliche und zeitliche Summation).\n\tHier bei der neuro-muskulären Synapse entsteht bei einer überschwelligen Depolarisation ein muskuläres Aktionspotenzial (wieder Frequenz moduliert), das sich entlang des Sarkoplasmatischen Retikulums ausbreitet und so durch die Öffnung spannungsabhängiger Calciumionenkanäle an den transversalen Tubuli die Muskelkontraktion auslöst.
''',
'5':'''
Der Neurotransmitter löst sich von den transmitterabhängigen Natriumionenkanälen und diese schließen sich. Acetylcholin wird durch das Enzym Acetylcholinesterase hydrolysiert und die Spaltprodukte werden wieder durch Endocytose in den Axonendknoten aufgenommen, und dort wieder in der funktionsfähigen Form in Vesikeln gespeichert.
''',
'botox':'''
Botulinustoxin hemmt die Ausschüttung des Neurotransmitters in den synaptischen Spalt. \nDie Erregungsübertragung wird unterbrochen.\nSymptome sind Muskelschwäche und schlaffe Atemlähmung.\nDieses Gift wird von Bakterien hergestellt, es löst die sogenannte "Lebensmittelvergiftung" aus. \nIn der plastischen Chirurgie wird es zur Faltenglättung eingesetzt.\n\tAuch das Gift der Kobra (Bungarotoxin) wirkt nach diesem Mechanismus.\nAnalog, allerdings nicht auf erregende Synapsen, wirkt das den "Wundstarrkrampf" auslösende Tetanustoxin, welches hemmende Synapsen hemmt und die Ausschüttung der Neurotransmitter Glycin und GABA hemmt.
''',
'curare':'''
Curare bindet als kompetitiver Hemmstoff (aufgrund seiner strukturellen Ähnlichkeit mit Acetylcholin) an die transmitterabhängigen Natriumionenkanäle der postsynaptischen Membran ohne sie zu öffnen.\nSymptome sind Muskelschwäche und schlaffe Atemlähmung.\nDa nicht alle Kanäle betroffen sind, kann man Prostigmin als Gegengift verwenden, einen Cholinesterase-Hemmer, der die Menge an Acetylcholin im synaptischen Spalt erhöht.\nDer Herzmuskel ist nicht betroffen, wichtig ist also eine künstliche Beatmung.\nCurare wird aus verschiedenen Lianenarten gewonnen.\n\tÄhnlich wirkt das (in der Tollkirsche enthaltene) Atropin, welches v.a. Herzstillstand auslöst.
''',
'muscarin':'''
Muscarin öffnet dauerhaft die transmitterabhängigen Natriumionenkanäle der postsynaptischen Membran. Es kommt zu einer übermäßigen Depolarisation.\nSymptome sind Zittern und krampfartige Atemlähmung.\nEs ist das Gift des Fliegenpilz.\n\tÄhnlich wirken das eigentlich von Futterinsekten hergestellte "Pfeilgiftfrosch-Gift" Batrachotoxin sowie das ebenfalls starke pflanzliche Fraßschutz-Nervengift Nikotin.
''',
'sarin':'''
Sarin hemmt das Enzym (Acetyl-)Cholinesterase. Der Neurotransmitter wird daher nicht gespalten und steht vermehrt im synapischen Spalt zur Verfügung. Es kommt zu einer dauerhaften Depolarisation und somit zu einer Übererregung.\nSymptome sind Zittern und krampfartige Atemlähmung.\nAls Gegengift kann Atropin gespritzt werden oder die Gabe von Oximen erfolgen, welche das aktive Zentrum des Enzyms teilweise wieder vom Sarin befreien können.\n\tÄhnlich wirken der chemische Kampfstoff Tabun sowie das Insektizid E 605.
''',

}
