#!/usr/bin/env python3
#-*- encoding=utf8 -*-

import os
from tkinter import *
from tkinter import scrolledtext
from tkinter import font
#import ScrolledText
#import tkFont
import random
# Datendatei
import sys
sys.path.insert(0, 'daten')
from auswahlknopfsammlung import auswahlknoepfe, ueberschriften
from textsammlung import texte
import webbrowser


class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame)
        self.frame2=Frame(frame)
        self.frame3=Frame(frame)
        self.frame4=Frame(frame)
        for f, row, column, columnspan, sticky in (
                (frame,            0, 0, 1, W),
                (self.frame1,      0, 0, 2, W),
                (self.frame2,      1, 0, 1, W),
                (self.frame3,      1, 1, 1, E+W),
                (self.frame4,      2, 0, 2, E+W)):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        # Rahmen 1: Kapitel-Auswahlmenü
        # Menüleiste als Rahmen innerhalb von Rahmen 1
        self.menueleiste=Frame(self.frame1, bd=2, relief=FLAT)
        master.config(menu=self.menueleiste)
        # Menüknöpfe
        self.mb_datei=Menubutton(self.menueleiste, text='Datei')
        self.mb_kapitel=Menubutton(self.menueleiste, text='Kapitel')
        # mit diesen zwei Menüknöpfen verknüpfte Drop-Down-Menüs
        # Datei zum Programm Beenden
        self.menue_datei=Menu(self.mb_datei, tearoff=0)
        self.menue_datei.insert_command(0, label='Beenden', command=root.destroy)
        self.mb_datei.config(menu=self.menue_datei)
        # Kapitel
        self.menue_kapitel=Menu(self.mb_kapitel, tearoff=0)
        # Untermenü 1: Bau der Nervenzelle
        self.menue_kapitel.insert_command(0, label='Bau der Nervenzelle', command=self.bau_der_nervenzelle)
        # Untermenü 2: Bau der Axonmembran
        self.menue_kapitel.insert_command(1, label='Bau der Axonmembran', command=self.bau_der_axonmembran)
        # Untermenü 3: Erregungsleitung
        self.menue_kapitel.choices3=Menu(self.menue_kapitel, tearoff=0)
        self.menue_kapitel.choices3.add_command(label='Chemische Grundlagen', command=self.chemische_grundlagen)
        self.menue_kapitel.choices3.add_command(label='Ruhepotenzial', command=self.ruhepotenzial)
        self.menue_kapitel.choices3.add_command(label='Aktionspotenzial', command=self.aktionspotenzial)
        self.menue_kapitel.choices3.add_command(label='Fortleitung an der Axonmembran', command=self.fortleitung_an_der_axonmembran)
        self.menue_kapitel.add_cascade(label='Erregungsleitung (elektrisch)', menu=self.menue_kapitel.choices3)
        # Untermenü 4: Erregungsübertragung
        self.menue_kapitel.choices4=Menu(self.menue_kapitel, tearoff=0)
        self.menue_kapitel.choices4.add_command(label='Bau der Synapse', command=self.bau_der_synapse)
        self.menue_kapitel.choices4.add_command(label='An einer neuromuskulären Synapse', command=self.neuromuskulaere_synapse)
        self.menue_kapitel.choices4.add_command(label='Drogen- und Giftwirkung', command=self.drogen_und_giftwirkung)
        self.menue_kapitel.add_cascade(label='Erregungsübertragung (chemisch)', menu=self.menue_kapitel.choices4)
        # Menü und Untermenüs hinzufügen
        self.mb_kapitel.config(menu=self.menue_kapitel)
        # Menüelemente anzeigen
        for i, row, column, sticky in (
                (self.menueleiste,    0, 0, E+W),
                (self.mb_datei,       0, 0, W),
                (self.mb_kapitel,     0, 1, W)):
            i.grid(row=row, column=column, sticky=sticky)

        # Rahmen 2: Zeichenfläche für die Bilddarstellung
        self.f2canvas1=Canvas(self.frame2, 
                              width=400, 
                              height=400, 
                              bg='white',
                              borderwidth=2,
                              relief=RAISED,
                              takefocus=1,
                              selectbackground='grey',
                              highlightbackground='grey')
        self.f2canvas1.bind("<Button-1>", self.mehr_info_event)
        
        # Rahmen 3: 
        self.f3text1=scrolledtext.ScrolledText(self.frame3, 
                                               height=22, 
                                               wrap=WORD, 
                                               bg='white', 
                                               width='45', 
                                               font=('arial', '11'), 
                                               state=DISABLED)

        for w, row, column, columnspan, sticky in (
                (self.f2canvas1, 0, 0, 1, E+W),
                (self.f3text1,   0, 1, 1, E+W+S+N),
                ):
            w.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        # Rahmen 4: Auswahl der Einzelbilder
        #           wird je nach Auswahl neu darunter angelegt

        ########################################################################
        ##                        Funktionen                                  ##
        ########################################################################
        
        ##  Auswahlmenüs in Rahmen 4 für die Einzelbilder  #####################
    def bau_der_nervenzelle(self):
        self.schluessel=str(self.bau_der_nervenzelle.__getattribute__('__name__'))
        #print(self.schluessel)
        self.mkRadiobuttons(self.frame4, self.schluessel)
        self.neue_vorauswahl()
        self.schreibe_ueberschrift(self.f2canvas1, ueberschriften[self.schluessel])
        
    def bau_der_axonmembran(self):
        self.schluessel=str(self.bau_der_axonmembran.__getattribute__('__name__'))
        #print(self.schluessel)
        self.mkRadiobuttons(self.frame4, self.schluessel)
        self.neue_vorauswahl()
        self.schreibe_ueberschrift(self.f2canvas1, ueberschriften[self.schluessel])
        
    def chemische_grundlagen(self):
        self.schluessel=str(self.chemische_grundlagen.__getattribute__('__name__'))
        #print(self.schluessel)
        self.mkRadiobuttons(self.frame4, self.schluessel)
        self.neue_vorauswahl()
        self.schreibe_ueberschrift(self.f2canvas1, ueberschriften[self.schluessel])
        
    def ruhepotenzial(self):
        self.schluessel=str(self.ruhepotenzial.__getattribute__('__name__'))
        #print(self.schluessel)
        self.mkRadiobuttons(self.frame4, self.schluessel)
        self.neue_vorauswahl()
        self.schreibe_ueberschrift(self.f2canvas1, ueberschriften[self.schluessel])
        
    def aktionspotenzial(self):
        self.schluessel=str(self.aktionspotenzial.__getattribute__('__name__'))
        #print(self.schluessel)
        self.mkRadiobuttons(self.frame4, self.schluessel)
        self.neue_vorauswahl()
        self.schreibe_ueberschrift(self.f2canvas1, ueberschriften[self.schluessel])
        
    def fortleitung_an_der_axonmembran(self):
        self.schluessel=str(self.fortleitung_an_der_axonmembran.__getattribute__('__name__'))
        #print(self.schluessel)
        self.mkRadiobuttons(self.frame4, self.schluessel)
        self.neue_vorauswahl()
        self.schreibe_ueberschrift(self.f2canvas1, ueberschriften[self.schluessel])
        
    def bau_der_synapse(self):
        self.schluessel=str(self.bau_der_synapse.__getattribute__('__name__'))
        #print(self.schluessel)
        self.mkRadiobuttons(self.frame4, self.schluessel)
        self.neue_vorauswahl()
        self.schreibe_ueberschrift(self.f2canvas1, ueberschriften[self.schluessel])
        
    def neuromuskulaere_synapse(self):
        self.schluessel=str(self.neuromuskulaere_synapse.__getattribute__('__name__'))
        #print(self.schluessel)
        self.mkRadiobuttons(self.frame4, self.schluessel)
        self.neue_vorauswahl()
        self.schreibe_ueberschrift(self.f2canvas1, ueberschriften[self.schluessel])
        
    def drogen_und_giftwirkung(self):
        self.schluessel=str(self.drogen_und_giftwirkung.__getattribute__('__name__'))
        #print(self.schluessel)
        self.mkRadiobuttons(self.frame4, self.schluessel)
        self.neue_vorauswahl()
        self.schreibe_ueberschrift(self.f2canvas1, ueberschriften[self.schluessel])
        
    def neue_vorauswahl(self):
        self.f3text1.config(state=NORMAL)
        self.f3text1.delete(0.0, END)
        self.f3text1.config(state=DISABLED)
        # bereits vorhandene Elemente löschen
        for i in self.f2canvas1.find_all():
            self.f2canvas1.delete(i)
        # Leinwand updaten
        self.f2canvas1.config(background='white')
        self.f2canvas1.update()
        
        ##  Jeweiligen Bild- und Text anzeigen  ################################
    def mkRadiobuttons(self, frame, schluessel):
        #print('mkRadiobuttons')
        liste=self.frame4.winfo_children()
        for i in liste:
            i.destroy()
        self.frame4.update()
        self.a1=StringVar()
        self.a1.set('X')
        mein_tupel=auswahlknoepfe[schluessel]
        for text, value in mein_tupel:
            self.r=Radiobutton(frame,
                               text=text,
                               variable=self.a1,
                               value=value,
                               anchor=W,
                               justify=LEFT,
                               indicatoron=0,
                               command=self.endauswahl,
                               padx=8)
            self.r.pack(anchor=W, fill=BOTH, expand=1)
        #self.a1.set(mein_tupel[0][1])
        #self.endauswahl()
    
    def endauswahl(self):
        a1=str(self.a1.get())
        #print('endauswahl', a1)
        self.zeige_text(a1)
        self.zeige_bild(a1)
        self.schreibe_ueberschrift(self.f2canvas1, ueberschriften[self.schluessel])
        
    def zeige_text(self, a1):
        anzeigetext=texte[a1].lstrip('\n')
        self.f3text1.config(state=NORMAL)
        self.f3text1.delete(0.0, END)
        self.f3text1.insert(0.0, anzeigetext)
        self.f3text1.config(state=DISABLED)

    def zeige_bild(self, a1):
        try:
            self.pfad='daten/img/'+self.schluessel+'/'+a1+'.gif'
            self.wechselbild=PhotoImage(file=self.pfad)
            # bereits vorhandene Elemente löschen
            for i in self.f2canvas1.find_all():
                self.f2canvas1.delete(i)
            # neues Bild zeichnen
            self.f2canvas1.create_image(0, 0, image=self.wechselbild, anchor=NW)
            # Leinwand updaten
            self.f2canvas1.update()
        except:
            pass
            #print('Bild '+self.pfad+' nicht vorhanden')

        ##  Zusatzinformationen oder Animationen im Browser anzeigen
    def mehr_info(self):
        #print('mehr_info')
        try:
            a1=str(self.a1.get())
            self.zeige_seite(a1)
        except:
            pass
    
    def schreibe_ueberschrift(self, canvas, ueberschrift):
        try:
            self.ueberschrifttext.destroy()
        except:
            pass
            #print('konnte nicht gelöscht werden')
        self.ueberschrifttext=canvas.create_text(5, 
                                                 5, 
                                                 text=ueberschrift, 
                                                 font=('arial', 10), 
                                                 anchor=NW,
                                                 justify=LEFT, 
                                                 state=NORMAL)
    
    def mehr_info_event(self, event):
        self.mehr_info()

    def zeige_seite(self, seitenname):
        self.seitenname=seitenname
        self.seiten_url='file://'+os.getcwd()+os.sep+'daten/html/'+self.schluessel+os.sep+self.seitenname+'.html'
        try:
            webbrowser.open(self.seiten_url)
        except:
            pass
################################################################################
root = Tk()
root.title('Nerver')
#root.option_add("*Text.Font", "arial 12")
#root.minsize()
app = Fenster(root)
root.mainloop()
