#!/usr/bin/env python3
#-*- encoding=utf8 -*-

'''
Copyright (C) 2011  Joachim Jakob

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os
from tkinter import *
from tkinter import font
import random
# Datendatei
import sys
sys.path.insert(0, 'daten')
from polymersammlung import polymere
import webbrowser

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame)
        self.frame2=Frame(frame, height=100)
        self.frame3=Frame(frame, bd=4)
        for f, row, column, columnspan, sticky in (
                (frame,            0, 0, 1, W),
                (self.frame1,      1, 0, 1, W),
                (self.frame2,      2, 0, 1, E+W),
                (self.frame3,      3, 0, 1, W)):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)
        
        # Rahmen 1: Auswahlmenü Polymertyp
        # Menüleiste als Rahmen innerhalb von Rahmen 1
        self.menueleiste=Frame(self.frame1, bd=2, relief=FLAT)
        master.config(menu=self.menueleiste)

        # Menüknöpfe
        self.mb_datei=Menubutton(self.menueleiste, text='Datei')
        self.mb_naturstoffe=Menubutton(self.menueleiste, text='Naturstoffe')
        self.mb_kunststoffe=Menubutton(self.menueleiste, text='Kunststoffe')
        self.mb_hilfe=Menubutton(self.menueleiste, text='Hilfe')
        # mit diesen drei Menüknöpfen verknüpfte Drop-Down-Menüs
        # Datei zum Programm Beenden
        self.menue_datei=Menu(self.mb_datei, tearoff=0)
        self.menue_datei.insert_command(0, 
                                        label='Beenden',
                                        command=root.destroy)
        self.mb_datei.config(menu=self.menue_datei)
        # Naturstoffe
        self.menue_naturstoffe=Menu(self.mb_naturstoffe, tearoff=0)
        self.menue_naturstoffe.insert_command(0, 
                                             label='Proteine...',
                                             command=self.festlegen_proteine)
        self.menue_naturstoffe.insert_command(1, 
                                             label='Kohlenhydrate...',
                                             command=self.festlegen_kohlenhydrate)
        self.menue_naturstoffe.insert_command(2, 
                                             label='Nucleinsäuren...',
                                             command=self.festlegen_nucleinsaeuren)
        self.mb_naturstoffe.config(menu=self.menue_naturstoffe)
        # Kunststoffe
        self.menue_kunststoffe=Menu(self.mb_kunststoffe, tearoff=0)
        self.menue_kunststoffe.insert_command(0, 
                                             label='Halbsynthetische...',
                                             command=self.festlegen_halbsynthetische)
        self.menue_kunststoffe.add_separator()
        self.menue_kunststoffe.insert_command(2, 
                                             label='Polymerisations...',
                                             command=self.festlegen_polymerisations)
        self.menue_kunststoffe.insert_command(3, 
                                             label='Polykondensations...',
                                             command=self.festlegen_polykondensations)
        self.menue_kunststoffe.insert_command(4, 
                                             label='Polyadditions...',
                                             command=self.festlegen_polyadditions)
        self.mb_kunststoffe.config(menu=self.menue_kunststoffe)
        # Hilfe
        self.menue_hilfe=Menu(self.mb_hilfe, tearoff=0)
        self.menue_hilfe.insert_command(0, 
                                             label='Info...',
                                             command=self.hilfe_anzeigen)
        self.mb_hilfe.config(menu=self.menue_hilfe)

        # Menüelemente anzeigen
        for i, row, column, sticky in (
                (self.menueleiste,    0, 0, E+W),
                (self.mb_datei,       0, 0, W),
                (self.mb_naturstoffe, 0, 1, W),
                (self.mb_kunststoffe, 0, 2, W),
                (self.mb_hilfe,       0, 3, W)):
            i.grid(row=row, column=column, sticky=sticky)
        
        # Rahmen 2: Auswahl der möglichen Monomere wird je nach Menüeintrag automatisch generiert
        # s.u. bei den Funktionen!

        # Rahmen 3: Anzeige der Eigenschaften
        self.f3l0=Label(self.frame3, 
                        text='Name des Polymers:',
                        anchor=NE,
                        justify=RIGHT)
        self.f3e0=Entry(self.frame3, 
                        background='white', 
                        disabledbackground='white',
                        disabledforeground='black',
                        width='60', 
                        font=('arial', '11'))
        self.f3l1=Label(self.frame3, 
                        text='Monomere:',
                        anchor=NE,
                        justify=RIGHT)
        self.f3c1=Canvas(self.frame3, width=500, height=200, bg='white')
        self.bild_monomere=PhotoImage(file='daten/img/start_monomere.gif')
        self.f3c1.create_image(0, 0, image=self.bild_monomere, anchor=NW)
        self.f3l2=Label(self.frame3, 
                        text='Bausteintyp \n(unabhängig von \nSeitenresten):',
                        anchor=NE,
                        justify=RIGHT)
        global a2
        a2=StringVar()
        self.f3r1=Radiobutton(self.frame3,
                              text='Nur ein Monomer mit einer C-C-Doppelbindung',
                              variable=a2,
                              value='eins_mit_eins',
                              anchor=W,
                              justify=LEFT)
        self.f3r2=Radiobutton(self.frame3,
                              text='Nur ein Monomer mit zwei verschiedenen funktionellen Gruppen',
                              variable=a2,
                              value='eins_mit_zwei',
                              anchor=W,
                              justify=LEFT)
        self.f3r3=Radiobutton(self.frame3,
                              text='Zwei verschiedene Monomere mit jeweils zweimal der gleichen funktionellen Gruppe',
                              variable=a2,
                              value='zwei_mit_eins',
                              anchor=W,
                              justify=LEFT)
        self.f3l3=Label(self.frame3, 
                        text='Verknüpfungsvorgang:',
                        anchor=NE,
                        justify=RIGHT)
        self.f3t1=Text(self.frame3, 
                       height=2,
                       wrap=WORD,
                       background='white', 
                       width='60', 
                       font=('arial', '11'))
        self.f3l4=Label(self.frame3, 
                        text='Verknüpfungsgruppe:',
                        anchor=NE,
                        justify=RIGHT)
        self.f3t2=Text(self.frame3, 
                       height=2,
                       wrap=WORD,
                       background='white', 
                       width='60', 
                       font=('arial', '11'))
        self.f3l5=Label(self.frame3, 
                        text='Strukturformelausschnitt \ndes Polymers:',
                        anchor=NE,
                        justify=RIGHT)
        self.f3c2=Canvas(self.frame3, width=500, height=200, bg="white")
        self.bild_polymerausschnitt=PhotoImage(file='daten/img/start_polymerausschnitt.gif')
        self.f3c2.create_image(0, 0, image=self.bild_polymerausschnitt, anchor=NW)
        self.f3l6=Label(self.frame3, 
                        text='Verzweigstyp:',
                        anchor=E,
                        justify=LEFT)
        global a3
        a3=StringVar()
        self.f3r4=Radiobutton(self.frame3,
                              text='Linear',
                              variable=a3,
                              value='linear',
                              anchor=W,
                              justify=LEFT)
        self.f3r5=Radiobutton(self.frame3,
                              text='Verzweigt bzw. dreidimensional vernetzt',
                              variable=a3,
                              value='vernetzt',
                              anchor=W,
                              justify=LEFT)
        self.f3bstruktur=Button(self.frame3, 
                              text='Weitere Informationen zur Struktur anzeigen', 
                              command=self.zeige_struktur,
                              state=DISABLED)
        
        for i, row, rowspan, column, columnspan, sticky in (
                (self.f3l0,          0, 1, 0, 1, N+E),
                (self.f3e0,          0, 1, 1, 1, W),
                (self.f3l1,          1, 1, 0, 1, N+E),
                (self.f3c1,          1, 1, 1, 1, W),
                (self.f3l2,          2, 3, 0, 1, N+E),
                (self.f3r1,          2, 1, 1, 1, W),
                (self.f3r2,          3, 1, 1, 1, W),
                (self.f3r3,          4, 1, 1, 1, W),
                (self.f3l3,          5, 1, 0, 1, N+E),
                (self.f3t1,          5, 1, 1, 1, W),
                (self.f3l4,          6, 1, 0, 1, N+E),
                (self.f3t2,          6, 1, 1, 1, W),
                (self.f3l5,          7, 1, 0, 1, N+E),
                (self.f3c2,          7, 1, 1, 1, W),
                (self.f3l6,          8, 1, 0, 1, N+E),
                (self.f3r4,          8, 1, 1, 1, W),
                (self.f3r5,          9, 1, 1, 1, W),
                (self.f3bstruktur,  10, 1, 1, 1, W)
                ):
            i.grid(row=row, rowspan=rowspan, 
                   column=column, columnspan=columnspan, sticky=sticky)


        ########################################################################

    def hilfe_anzeigen(self):
        self.help_url='http://chemie-lernprogramme.de/daten/help/polymerer/html/index.html'
        webbrowser.open(self.help_url)

    def festlegen_proteine(self):
        self.a0='proteine'
        self.mkRadiobuttons(self.frame2, self.a0)
        a1.set('1_lys_ala')
        self.r1.select()
        self.auswahl_ausgangsstoffe()
        
    def festlegen_kohlenhydrate(self):
        self.a0='kohlenhydrate'
        self.mkRadiobuttons(self.frame2, self.a0)
        a1.set('3_adglucopyr')
        self.r1.select()
        self.auswahl_ausgangsstoffe()
        
    def festlegen_nucleinsaeuren(self):
        self.a0='nucleinsaeuren'
        self.mkRadiobuttons(self.frame2, self.a0)
        a1.set('3b_adenin_uracil')
        self.r1.select()
        self.auswahl_ausgangsstoffe()
        
    def festlegen_halbsynthetische(self):
        self.a0='halbsynthetische'
        self.mkRadiobuttons(self.frame2, self.a0)
        a1.set('5_methylbutadien')
        self.r1.select()
        self.auswahl_ausgangsstoffe()
        
    def festlegen_polymerisations(self):
        self.a0='polymerisations'
        self.mkRadiobuttons(self.frame2, self.a0)
        a1.set('7_ethen')
        self.r1.select()
        self.auswahl_ausgangsstoffe()
        
    def festlegen_polykondensations(self):
        self.a0='polykondensations'
        self.mkRadiobuttons(self.frame2, self.a0)
        a1.set('14_hexansaeure_diaminohexan')
        self.r1.select()
        self.auswahl_ausgangsstoffe()
        
    def festlegen_polyadditions(self):
        self.a0='polyadditions'
        self.mkRadiobuttons(self.frame2, self.a0)
        a1.set('18_diisocyanatohexan_butandiol')
        self.r1.select()
        self.auswahl_ausgangsstoffe()
        
    def auswahl_ausgangsstoffe(self):
        global a1
        self.ausgangsstoffe=str(a1.get())
        #print(self.ausgangsstoffe)
        self.polymername=str(polymere[self.ausgangsstoffe][0])
        self.bausteintyp=str(polymere[self.ausgangsstoffe][1])
        self.herstellung=str(polymere[self.ausgangsstoffe][2])
        self.gruppe=str(polymere[self.ausgangsstoffe][3])
        self.verzweigung=str(polymere[self.ausgangsstoffe][4])
        self.f3e0.delete(0, END)
        self.f3e0.insert(0, self.polymername)
        self.f3t1.delete(1.0, END)
        self.f3t2.delete(1.0, END)
        self.f3t1.insert(END, self.herstellung)
        self.f3t2.insert(END, self.gruppe)
        a2.set(self.bausteintyp)
        a3.set(self.verzweigung)
        self.bild_monomere=PhotoImage(file='daten/img/'+self.ausgangsstoffe+os.sep+'monomere.gif')
        self.f3c1.create_image(0, 0, image=self.bild_monomere, anchor=NW)
        self.bild_polymerausschnitt=PhotoImage(file='daten/img/'+self.ausgangsstoffe+os.sep+'polymerausschnitt.gif')
        self.f3c2.create_image(0, 0, image=self.bild_polymerausschnitt, anchor=NW)
        self.f3bstruktur.config(state=NORMAL)
        
    def mkRadiobuttons(self, frame, a0):
        self.l1=Label(frame,
                      text='Wähle die Ausgangsstoffe aus:')
        try:
            self.r1.destroy()
            self.r2.destroy()
            self.r3.destroy()
            self.r4.destroy()
            self.r5.destroy()
            self.r6.destroy()
            self.r7.destroy()
        except:
            pass
        self.a0=a0
        global a1
        a1=StringVar()
        if self.a0 == 'proteine':
            self.r1=Radiobutton(frame,
                                text='Lysin und Alanin',
                                variable=a1,
                                value='1_lys_ala',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r2=Radiobutton(frame,
                                text='Alanin und Lysin',
                                variable=a1,
                                value='2_ala_lys',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r1.pack(anchor=W)
            self.r2.pack(anchor=W)
        elif self.a0 == 'kohlenhydrate':
            self.r1=Radiobutton(frame,
                                text='α-D-Glucopyranose',
                                variable=a1,
                                value='3_adglucopyr',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r2=Radiobutton(frame,
                                text='β-D-Glucopyranose',
                                variable=a1,
                                value='4_bdglucopyr',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r1.pack(anchor=W)
            self.r2.pack(anchor=W)
        elif self.a0 == 'nucleinsaeuren':
            self.r1=Radiobutton(frame,
                                text='Adenosinmonophosphat (mit der Base Adenin) und \nUridinmonophosphat (mit der Base Uracil)',
                                variable=a1,
                                value='3b_adenin_uracil',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r2=Radiobutton(frame,
                                text='Desoxythymidinmonophosphat (mit der Base Thymin) und \nDesoxyadenosinmonophosphat (mit der Base Adenin)',
                                variable=a1,
                                value='3c_thymin_adenin',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r1.pack(anchor=W)
            self.r2.pack(anchor=W)
        
        elif self.a0 == 'halbsynthetische':
            self.r1=Radiobutton(frame,
                                text='2-Methyl-buta-1,3-dien (Isopren, Vinylethylen)',
                                variable=a1,
                                value='5_methylbutadien',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r2=Radiobutton(frame,
                                text='β-D-Glucopyranose und Nitriersäure',
                                variable=a1,
                                value='6_cellulose_nitriersaeure',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r1.pack(anchor=W)
            self.r2.pack(anchor=W)
        elif self.a0 == 'polymerisations':
            self.r1=Radiobutton(frame,
                                text='Ethen (Ethylen)',
                                variable=a1,
                                value='7_ethen',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r2=Radiobutton(frame,
                                text='Chlorethen (Vinylchlorid)',
                                variable=a1,
                                value='8_chlorethen',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r3=Radiobutton(frame,
                                text='Tetrafluorethen (Tetrafluorethylen)',
                                variable=a1,
                                value='9_tetrafluorethen',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r4=Radiobutton(frame,
                                text='Phenylethen (Styrol)',
                                variable=a1,
                                value='10_phenylethen',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r5=Radiobutton(frame,
                                text='Propen (Propylen)',
                                variable=a1,
                                value='11_propen',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r6=Radiobutton(frame,
                                text='Acrylnitril (Vinylcyanid)',
                                variable=a1,
                                value='12_acrylnitril',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r7=Radiobutton(frame,
                                text='Acrylsäuremethylester (Methylacrylat)',
                                variable=a1,
                                value='13_acrylsaeuremethylester',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r1.pack(anchor=W)
            self.r2.pack(anchor=W)
            self.r3.pack(anchor=W)
            self.r4.pack(anchor=W)
            self.r5.pack(anchor=W)
            self.r6.pack(anchor=W)
            self.r7.pack(anchor=W)
        elif self.a0 == 'polykondensations':
            self.r1=Radiobutton(frame,
                                text='Hexandisäure und 1,6-Diaminohexan',
                                variable=a1,
                                value='14_hexansaeure_diaminohexan',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r2=Radiobutton(frame,
                                text='6-Amino-hexansäure',
                                variable=a1,
                                value='15_aminohexansaeure',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r3=Radiobutton(frame,
                                text='Terephthalsäure und Ethan-1,2-diol',
                                variable=a1,
                                value='16_terephthalsaeure_ethandiol',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r4=Radiobutton(frame,
                                text='Harnstoff und Formaldehyd',
                                variable=a1,
                                value='17_harnstoff_formaldehyd',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r1.pack(anchor=W)
            self.r2.pack(anchor=W)
            self.r3.pack(anchor=W)
            self.r4.pack(anchor=W)
        elif self.a0 == 'polyadditions':
            self.r1=Radiobutton(frame,
                                text='1,6-Diisocyanato-hexan und But-1,4-diol',
                                variable=a1,
                                value='18_diisocyanatohexan_butandiol',
                                anchor=W,
                                justify=LEFT,
                                command=self.auswahl_ausgangsstoffe)
            self.r1.pack(anchor=W)
        self.frame2.config(height=250)

    def zeige_struktur(self):
        self.animdir='daten/struktur'
        global a1
        self.ausgangsstoffe=str(a1.get())
        self.struktur_url='http://chemie-lernprogramme.de/daten/help/polymerer/html/'+self.ausgangsstoffe+'.html'
        webbrowser.open(self.struktur_url)
        self.f3bstruktur.config(state=DISABLED)


################################################################################
root = Tk()
root.title('Polymerer')
root.minsize(width=600, height=600)
app = Fenster(root)
root.mainloop()
