#!/usr/bin/env python3
#-*- encoding=utf8 -*-
import os
from tkinter import *
from tkinter import font
# Textdatei
import sys
sys.path.insert(0, 'daten')
from textdaten import genotypen
import webbrowser

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame, pady=2, padx=2)
        self.frame2=Frame(frame, pady=4, padx=2)
        self.frame3=Frame(frame)
        for f, row, column, columnspan, sticky in (
                (frame,       0, 0, 1, E+W),
                (self.frame1, 0, 0, 1, E+W),
                (self.frame2, 1, 0, 1, E+W),
                (self.frame3, 2, 0, 1, E+W),
                ):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        # Rahmen 1: Auswahl dominant oder rezessiv und autosomal oder gonosomal und autosomal möglich
        # Erbgangsauswahl: rezessiv oder dominant
        self.v1=StringVar()
        self.v1.set('X')
        self.f1r1=Radiobutton(self.frame1, variable=self.v1, 
                              value='rezessiv', text='Gesundes Ehepaar & mindestens ein krankes Kind', 
                              command=self.auswahl_v1, justify=LEFT)
        self.f1r2=Radiobutton(self.frame1, variable=self.v1, 
                              value='dominant', text='Krankes Ehepaar & mindestens ein gesundes Kind', 
                              command=self.auswahl_v1, justify=LEFT)
        # Chromosomenauswahl: autosomal oder keine Unterscheidung zwischen autosomal und gonosomal möglich
        self.v2=StringVar()
        self.v2.set('X')
        self.f1r3=Radiobutton(self.frame1, variable=self.v2, 
                              value='autosomal', text='Gesunder Vater & mindestens eine kranke Tochter;\nauch gesunde Töchter sind möglich', 
                              command=self.auswahl_v2, state=DISABLED, justify=LEFT)
        self.f1r4=Radiobutton(self.frame1, variable=self.v2, 
                              value='beides', text='Gesunder Vater & ausschließlich gesunde Töchter', 
                              command=self.auswahl_v2, state=DISABLED, justify=LEFT)
        # Chromosomenauswahl: autosomal oder keine Unterscheidung zwischen autosomal und gonosomal möglich
        self.v3=StringVar()
        self.v3.set('X')
        self.f1r5=Radiobutton(self.frame1, variable=self.v3, 
                              value='autosomal', text='Kranker Vater & mindestens eine gesunde Tochter;\nauch kranke Töchter sind möglich', 
                              command=self.auswahl_v3, state=DISABLED, justify=LEFT)
        self.f1r6=Radiobutton(self.frame1, variable=self.v3, 
                              value='beides', text='Kranker Vater & ausschließlich kranke Töchter', 
                              command=self.auswahl_v3, state=DISABLED, justify=LEFT)

        # Rahmen 2: Zeichenfläche und Textbeschreibung
        self.f2canvas1=Canvas(self.frame2, width=560, height=200, bg='white')
        self.bild1=PhotoImage(file='daten/img/start.gif')
        self.f2canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
        self.f2text1=Text(self.frame2, 
                          background='white',
                          height='5', 
                          width='60', 
                          wrap=WORD,
                          state=DISABLED,
                          font=('courier', '11'))
        self.f2entry1=Entry(self.frame2, 
                            width='60',
                            background='white',
                            disabledbackground='white',
                            disabledforeground='black',
                            state=DISABLED,
                            font=('arial', '11'))
        self.icon_uebersicht=PhotoImage(file='daten/icons/uebersicht.gif')
        self.f2b1=Button(self.frame2, 
                         #text='Zurücksetzen', 
                         command=self.zeige_uebersicht,
                         image=self.icon_uebersicht,
                         compound=LEFT)
        self.f2b1.icon_uebersicht=self.icon_uebersicht

        # Rahmen 3: Navigation
        self.icon_zurueck=PhotoImage(file='daten/icons/zuruecksetzen.gif')
        self.f3b1=Button(self.frame3, 
                         text='Zurücksetzen', 
                         command=self.zurueck_setzen,
                         image=self.icon_zurueck,
                         compound=LEFT)
        self.f3b1.icon_zurueck=self.icon_zurueck
        self.icon_exit=PhotoImage(file='daten/icons/beenden.gif')
        self.f3b2=Button(self.frame3, 
                         text='Beenden', 
                         command=root.destroy,
                         image=self.icon_exit,
                         compound=LEFT)
        self.f3b2.icon_exit=self.icon_exit

        ## Fensterelemente setzen
        for i, row, column, rowspan, columnspan, sticky in (
                (self.f1r1, 0, 0, 1, 2, W),
                (self.f1r3, 1, 0, 1, 1, W),         (self.f1r4, 1, 1, 1, 1, W),
                (self.f1r2, 2, 0, 1, 2, W),
                (self.f1r5, 3, 0, 1, 1, W),         (self.f1r6, 3, 1, 1, 1, W),
                (self.f2canvas1, 0, 0, 1, 2, E+W), 
                (self.f2text1,   1, 0, 1, 2, E+W),
                (self.f2entry1,  2, 0, 1, 1, E+W),    (self.f2b1, 2, 1, 1, 1, W),
                (self.f3b1, 0, 0, 1, 1, E+W),       (self.f3b2, 0, 1, 1, 1, E+W)):
            i.grid(row=row, column=column, rowspan=rowspan, columnspan=columnspan, sticky=sticky)
        
        ########################################################################
        ##                           Funktionen                               ##
        ########################################################################

    def auswahl_v1(self):
        typ=str(self.v1.get())
        self.v2.set('X')
        self.v3.set('X')
        for i in (self.f1r3, self.f1r4, self.f1r5, self.f1r6):
            i.config(state=DISABLED)
        self.setze_text(typ)
        self.setze_bild(typ)
        if typ == 'rezessiv':
            for i in (self.f1r3, self.f1r4):
                i.config(state=NORMAL)
            self.f1r2.config(state=DISABLED)
        elif typ == 'dominant':
            for i in (self.f1r5, self.f1r6):
                i.config(state=NORMAL)
            self.f1r1.config(state=DISABLED)
        #print('auswahl_v1', typ)
    
    def auswahl_v2(self):
        typ=str(self.v1.get())
        chromosom=str(self.v2.get())
        self.setze_text(typ+'_'+chromosom)
        self.setze_bild(typ+'_'+chromosom)
        #print('auswahl_v2', typ, chromosom)
        
    def auswahl_v3(self):
        typ=str(self.v1.get())
        chromosom=str(self.v3.get())
        self.setze_text(typ+'_'+chromosom)
        self.setze_bild(typ+'_'+chromosom)
        #print('auswahl_v1', typ, chromosom)
    
    def setze_text(self, schluessel):
        text1=genotypen[schluessel][0].strip('\n')
        self.f2text1.config(state=NORMAL)
        self.f2text1.delete(0.0, END)
        self.f2text1.insert(0.0, text1)
        self.f2text1.config(state=DISABLED)
        text2=genotypen[schluessel][1]
        self.f2entry1.config(state=NORMAL)
        self.f2entry1.delete(0, END)
        self.f2entry1.insert(0, text2)
        self.f2entry1.config(state=DISABLED)
    
    def setze_bild(self, schluessel):
        for i in self.f2canvas1.find_all():
            self.f2canvas1.delete(i)
        bildpfad=str('daten/img/'+schluessel+'.gif')
        self.bild1=PhotoImage(file=bildpfad)
        self.f2canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
        self.f2canvas1.update()
    
    def zurueck_setzen(self):
        self.v1.set('X')
        self.v2.set('X')
        self.v3.set('X')
        for i, state in (
                (self.f1r1, NORMAL),
                (self.f1r3, DISABLED), (self.f1r4, DISABLED),
                (self.f1r2, NORMAL),
                (self.f1r5, DISABLED), (self.f1r6, DISABLED)):
            i.config(state=state)
        self.f2text1.config(state=NORMAL)
        self.f2text1.delete(0.0, END)
        self.f2text1.config(state=DISABLED)
        self.f2entry1.config(state=NORMAL)
        self.f2entry1.delete(0, END)
        self.f2entry1.config(state=DISABLED)
        for i in self.f2canvas1.find_all():
            self.f2canvas1.delete(i)
        self.f2canvas1.update()
        #print('zurueck_setzen')

    def zeige_uebersicht(self):
        self.seiten_url='file://'+os.getcwd()+os.sep+'daten/html/uebersicht.html'
        try:
            webbrowser.open(self.seiten_url)
        except:
            pass


################################################################################
root = Tk()
root.title('Stammbäumer')
app = Fenster(root)
root.mainloop()
