#!/usr/bin/env python3
#-*- encoding=utf8 -*-

import os
from tkinter import *
#from tkinter import scrolledtext
#from tkinter import font
#import ScrolledText
#import tkFont
import random
# Datendatei
import sys
sys.path.insert(0, 'daten')
from textsammlung import texte
import webbrowser


class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame)
        self.frame2=Frame(frame)
        self.frame3=Frame(frame)
        for f, row, column, columnspan, sticky in (
                (frame,            0, 0, 1, W),
                (self.frame1,      0, 0, 1, W),
                (self.frame2,      1, 0, 1, E+W),
                (self.frame3,      2, 0, 1, E+W),):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        # Rahmen 1: Kapitel-Auswahlmenü
        # Menüleiste als Rahmen innerhalb von Rahmen 1
        self.menueleiste=Frame(self.frame1, bd=2, relief=FLAT)
        master.config(menu=self.menueleiste)
        # Menüknöpfe
        self.mb_datei=Menubutton(self.menueleiste, text='Datei')
        self.mb_assimilation=Menubutton(self.menueleiste, text='Assimilation')
        self.mb_dissimilation=Menubutton(self.menueleiste, text='Dissimilation')
        # mit diesen zwei Menüknöpfen verknüpfte Drop-Down-Menüs
        ## Datei zum Programm Beenden
        self.menue_datei=Menu(self.mb_datei, tearoff=0)
        self.menue_datei.insert_command(0, label='Beenden', command=root.destroy)
        self.mb_datei.config(menu=self.menue_datei)
        ## Assimilation
        self.menue_assimilation=Menu(self.mb_assimilation, tearoff=0)
        # Untermenü 1: Fotosynthese
        self.menue_assimilation.choices1=Menu(self.menue_assimilation, tearoff=0)
        self.menue_assimilation.choices1.add_command(label='Lichtreaktion', command=self.lichtreaktion)
        self.menue_assimilation.choices1.add_command(label='Calvin-Zyklus', command=self.calvinzyklus)
        self.menue_assimilation.add_cascade(label='Fotosynthese', menu=self.menue_assimilation.choices1)
        # Menü und Untermenüs hinzufügen
        self.mb_assimilation.config(menu=self.menue_assimilation)
        ## Dissimilation
        self.menue_dissimilation=Menu(self.mb_dissimilation, tearoff=0)
        # Untermenü 1: Zellatmung
        self.menue_dissimilation.choices1=Menu(self.menue_dissimilation, tearoff=0)
        self.menue_dissimilation.choices1.add_command(label='Glykolyse', command=self.glykolyse)
        self.menue_dissimilation.choices1.add_command(label='Citratzyklus (mit vorheriger Decarboxylierung)', command=self.citratzyklus)
        self.menue_dissimilation.choices1.add_command(label='Endoxidation', command=self.endoxidation)
        self.menue_dissimilation.add_cascade(label='Zellatmung', menu=self.menue_dissimilation.choices1)
        # Untermenü 2: Alkoholische Gärung
        self.menue_dissimilation.choices2=Menu(self.menue_dissimilation, tearoff=0)
        self.menue_dissimilation.choices2.add_command(label='Glykolyse', command=self.glykolyse)
        self.menue_dissimilation.choices2.add_command(label='Decarboxylierung', command=self.decarboxylierung)
        self.menue_dissimilation.choices2.add_command(label='Reduktionsschritt', command=self.reduktionsschritt_alk)
        self.menue_dissimilation.add_cascade(label='Alkoholische Gärung', menu=self.menue_dissimilation.choices2)
        # Untermenü 3: Milchsäure Gärung
        self.menue_dissimilation.choices3=Menu(self.menue_dissimilation, tearoff=0)
        self.menue_dissimilation.choices3.add_command(label='Glykolyse', command=self.glykolyse)
        self.menue_dissimilation.choices3.add_command(label='Reduktionsschritt', command=self.reduktionsschritt_milch)
        self.menue_dissimilation.add_cascade(label='Milchsäure Gärung', menu=self.menue_dissimilation.choices3)
        # Menü und Untermenüs hinzufügen
        self.mb_dissimilation.config(menu=self.menue_dissimilation)
        # Menüelemente anzeigen
        for i, row, column, sticky in (
                (self.menueleiste,          0, 0, E+W),
                (self.mb_datei,             0, 0, W),
                (self.mb_assimilation,     0, 1, W),
                (self.mb_dissimilation,     0, 2, W)):
            i.grid(row=row, column=column, sticky=sticky)

        # Rahmen 2: Textanzeige und Rahmen 3: Schema-Auswahl-Buttons
        self.f2l1=Label(self.frame2, text='Ort in der Zelle:', anchor=NE, justify=RIGHT)
        self.f2e1=Text(self.frame2,width=60, height=2, bg='white', state=DISABLED, wrap=WORD)
        self.f2l2=Label(self.frame2, text='Ausgangsstoffe:', anchor=NE, justify=RIGHT)
        self.f2e2=Text(self.frame2,width=60, height=2, bg='white', state=DISABLED, wrap=WORD)
        self.f2l3=Label(self.frame2, text='Zwischenprodukte:', anchor=NE, justify=RIGHT)
        self.f2e3=Text(self.frame2,width=60, height=2, bg='white', state=DISABLED, wrap=WORD)
        self.f2l4=Label(self.frame2, text='Endstoffe:', anchor=NE, justify=RIGHT)
        self.f2e4=Text(self.frame2,width=60, height=2, bg='white', state=DISABLED, wrap=WORD)
        self.f2l5=Label(self.frame2, text='Bilanz der Energieträger:', anchor=NE, justify=RIGHT)
        self.f2e5=Text(self.frame2,width=60, height=2, bg='white', state=DISABLED, wrap=WORD)
        self.f2l6=Label(self.frame2, text='Bilanz der Reduktionsäquivalente:', anchor=NE, justify=RIGHT)
        self.f2e6=Text(self.frame2,width=60, height=2, bg='white', state=DISABLED, wrap=WORD)
        self.f2l7=Label(self.frame2, text='Exergonische Vorgänge:', anchor=NE, justify=RIGHT)
        self.f2e7=Text(self.frame2,width=60, height=2, bg='white', state=DISABLED, wrap=WORD)
        self.f2l8=Label(self.frame2, text='Endergonische Vorgänge:', anchor=NE, justify=RIGHT)
        self.f2e8=Text(self.frame2,width=60, height=2, bg='white', state=DISABLED, wrap=WORD)
        self.f3b1=Button(self.frame3, text='Membranvorgänge-Schema', state=DISABLED, command=self.membranvorgaenge)
        self.f3b2=Button(self.frame3, text='C-Körperschema', state=DISABLED, command=self.ckoerperschema)
        for w, row, column, columnspan, sticky in (
                (self.f2l1, 0, 0, 1, E+N), (self.f2e1, 0, 1, 1, E+W),
                (self.f2l2, 1, 0, 1, E+N), (self.f2e2, 1, 1, 1, E+W),
                (self.f2l3, 2, 0, 1, E+N), (self.f2e3, 2, 1, 1, E+W),
                (self.f2l4, 3, 0, 1, E+N), (self.f2e4, 3, 1, 1, E+W),
                (self.f2l5, 4, 0, 1, E+N), (self.f2e5, 4, 1, 1, E+W),
                (self.f2l6, 5, 0, 1, E+N), (self.f2e6, 5, 1, 1, E+W),
                (self.f2l7, 6, 0, 1, E+N), (self.f2e7, 6, 1, 1, E+W),
                (self.f2l8, 7, 0, 1, E+N), (self.f2e8, 7, 1, 1, E+W),
                (self.f3b1, 0, 0, 1, E+N), (self.f3b2, 0, 1, 1, E+W),
                ):
            w.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)
        self.schluessel='X'
        
        ########################################################################
        ##                        Funktionen                                  ##
        ########################################################################
        
        ##  Auswahlmenüs in Rahmen 2 für die Teilschritte  #####################
    def lichtreaktion(self):
        self.schluessel=str(self.lichtreaktion.__getattribute__('__name__'))
        for i, state in ((self.f3b1, NORMAL), 
                         (self.f3b2, DISABLED)):
            i.config(state=state)
        self.zeige_text(self.schluessel)
        
    def calvinzyklus(self):
        self.schluessel=str(self.calvinzyklus.__getattribute__('__name__'))
        for i, state in ((self.f3b1, DISABLED), 
                         (self.f3b2, NORMAL)):
            i.config(state=state)
        self.zeige_text(self.schluessel)
    
    def glykolyse(self):
        self.schluessel=str(self.glykolyse.__getattribute__('__name__'))
        for i, state in ((self.f3b1, DISABLED), 
                         (self.f3b2, NORMAL)):
            i.config(state=state)
        self.zeige_text(self.schluessel)
    
    def citratzyklus(self):
        self.schluessel=str(self.citratzyklus.__getattribute__('__name__'))
        for i, state in ((self.f3b1, DISABLED), 
                         (self.f3b2, NORMAL)):
            i.config(state=state)
        self.zeige_text(self.schluessel)
        
    def endoxidation(self):
        self.schluessel=str(self.endoxidation.__getattribute__('__name__'))
        for i, state in ((self.f3b1, NORMAL), 
                         (self.f3b2, DISABLED)):
            i.config(state=state)
        self.zeige_text(self.schluessel)
    
    def decarboxylierung(self):
        self.schluessel=str(self.decarboxylierung.__getattribute__('__name__'))
        for i, state in ((self.f3b1, DISABLED), 
                         (self.f3b2, NORMAL)):
            i.config(state=state)
        self.zeige_text(self.schluessel)
        
    def reduktionsschritt_alk(self):
        self.schluessel=str(self.reduktionsschritt_alk.__getattribute__('__name__'))
        for i, state in ((self.f3b1, DISABLED), 
                         (self.f3b2, NORMAL)):
            i.config(state=state)
        self.zeige_text(self.schluessel)
        
    def reduktionsschritt_milch(self):
        self.schluessel=str(self.reduktionsschritt_milch.__getattribute__('__name__'))
        for i, state in ((self.f3b1, DISABLED), 
                         (self.f3b2, NORMAL)):
            i.config(state=state)
        self.zeige_text(self.schluessel)
        
        ##  Auswahlbuttons in Rahmen 3 fuer die Schemadarstellungen  ###########
    def ckoerperschema(self):
        self.zeige_seite(self.schluessel)
        
    def membranvorgaenge(self):
        self.zeige_seite(self.schluessel)

        ##  Texte holen und anzeigen
    def zeige_text(self, schluessel):
        for s, entry in (
                ('ort',         self.f2e1), 
                ('ed',          self.f2e2),
                ('zwi',         self.f2e3),
                ('prod',        self.f2e4),
                ('atp',         self.f2e5),
                ('redaeq',      self.f2e6),
                ('exerg',       self.f2e7),
                ('enderg',      self.f2e8),
                ):
            neuer_text=texte[schluessel][s]
            entry.config(state=NORMAL)
            entry.delete(0.0, END)
            entry.insert(0.0, neuer_text)
            entry.config(state=DISABLED)

        ## C-Körperschema oder Animation der Membranvorgänge anzeigen
    def zeige_seite(self, schluessel):
        self.seiten_url='file://'+os.getcwd()+os.sep+'daten/html/'+schluessel+'.html'
        try:
            webbrowser.open(self.seiten_url)
        except:
            pass

################################################################################
root = Tk()
root.title('Stoffwechsler')
root.option_add('*Text.Font', 'arial 11')
#root.minsize()
app = Fenster(root)
root.mainloop()
