#!/usr/bin/env python3
#-*- encoding=utf8 -*-
import os
from tkinter import *
from tkinter import font
# Textdatei
import sys
sys.path.insert(0, 'daten')
from textdaten import datensammlung
import webbrowser

class Fenster:
    def __init__(self, master):
        frame=Frame(master)
        self.frame1=Frame(frame, pady=4, padx=2)
        self.frame2=Frame(frame, pady=4, padx=2)
        self.frame3=Frame(frame, pady=4, padx=2)
        self.frame4=Frame(frame, pady=4, padx=2)
        self.frame5=Frame(frame, pady=4, padx=2)
        for f, row, column, columnspan, sticky in (
                (frame,       0, 0, 1, E+W),
                (self.frame1, 0, 0, 1, E+W),
                (self.frame2, 1, 0, 1, E+W),
                (self.frame3, 2, 0, 1, E+W),
                (self.frame4, 3, 0, 1, E+W),
                (self.frame5, 4, 0, 1, E+W),
                ):
            f.grid(row=row, column=column, columnspan=columnspan, sticky=sticky)

        # Rahmen 1: Auswahl des Vorgangs sowie der Phase
        self.f1l1=Label(self.frame1, text='Mitose')
        self.f1l2=Label(self.frame1, text='Meiose')
        self.f1l3=Label(self.frame1, text='Befruchtung')
        self.f1l4=Label(self.frame1, text='Reduktionsteilung')
        self.f1l5=Label(self.frame1, text='Äquationsteilung')
        self.f1l6=Label(self.frame1, text='Prophase', justify=LEFT, anchor=W)
        self.f1l7=Label(self.frame1, text='Metaphase', justify=LEFT, anchor=W)
        self.f1l8=Label(self.frame1, text='Anaphase', justify=LEFT, anchor=W)
        self.f1l9=Label(self.frame1, text='Telophase', justify=LEFT, anchor=W)
        self.f1l10=Label(self.frame1, text='Verschmelzen\nder Kerne', justify=LEFT, anchor=W)
        self.f1l11=Label(self.frame1, text='Synthesephase', justify=LEFT, anchor=W)
        global v
        v=StringVar()
        v.set('X')
        self.bild_schema=PhotoImage(file='daten/icons/schema.gif')
        self.bild_real=PhotoImage(file='daten/icons/real.gif')
        # Mitose
        self.f1r1=Radiobutton(self.frame1, variable=v, value='mit_pro_schema',  text='', indicatoron=0, command=self.hole_werte, image=self.bild_schema, compound=LEFT)
        self.f1r2=Radiobutton(self.frame1, variable=v, value='mit_pro_real',    text='', indicatoron=0, command=self.hole_werte, image=self.bild_real, compound=LEFT)
        self.f1r3=Radiobutton(self.frame1, variable=v, value='mit_met_schema',  text='', indicatoron=0, command=self.hole_werte, image=self.bild_schema, compound=LEFT)
        self.f1r4=Radiobutton(self.frame1, variable=v, value='mit_met_real',    text='', indicatoron=0, command=self.hole_werte, image=self.bild_real, compound=LEFT)
        self.f1r5=Radiobutton(self.frame1, variable=v, value='mit_ana_schema',  text='', indicatoron=0, command=self.hole_werte, image=self.bild_schema, compound=LEFT)
        self.f1r6=Radiobutton(self.frame1, variable=v, value='mit_ana_real',    text='', indicatoron=0, command=self.hole_werte, image=self.bild_real, compound=LEFT)
        self.f1r7=Radiobutton(self.frame1, variable=v, value='mit_tel_schema',  text='', indicatoron=0, command=self.hole_werte, image=self.bild_schema, compound=LEFT)
        self.f1r8=Radiobutton(self.frame1, variable=v, value='mit_tel_real',    text='', indicatoron=0, command=self.hole_werte, image=self.bild_real, compound=LEFT)
        # Reduktionsteilung
        self.f1r9=Radiobutton(self.frame1, variable=v,  value='red_pro_schema', text='', indicatoron=0, command=self.hole_werte, image=self.bild_schema, compound=LEFT)
        self.f1r10=Radiobutton(self.frame1, variable=v, value='red_pro_real',   text='', indicatoron=0, command=self.hole_werte, image=self.bild_real, compound=LEFT)
        self.f1r11=Radiobutton(self.frame1, variable=v, value='red_met_schema', text='', indicatoron=0, command=self.hole_werte, image=self.bild_schema, compound=LEFT)
        self.f1r12=Radiobutton(self.frame1, variable=v, value='red_met_real',   text='', indicatoron=0, command=self.hole_werte, image=self.bild_real, compound=LEFT)
        self.f1r13=Radiobutton(self.frame1, variable=v, value='red_ana_schema', text='', indicatoron=0, command=self.hole_werte, image=self.bild_schema, compound=LEFT)
        self.f1r14=Radiobutton(self.frame1, variable=v, value='red_ana_real',   text='', indicatoron=0, command=self.hole_werte, image=self.bild_real, compound=LEFT)
        self.f1r15=Radiobutton(self.frame1, variable=v, value='red_tel_schema', text='', indicatoron=0, command=self.hole_werte, image=self.bild_schema, compound=LEFT)
        self.f1r16=Radiobutton(self.frame1, variable=v, value='red_tel_real',   text='', indicatoron=0, command=self.hole_werte, image=self.bild_real, compound=LEFT)
        # Äquationsteilung
        self.f1r17=Radiobutton(self.frame1, variable=v, value='aeq_pro_schema', text='', indicatoron=0, command=self.hole_werte, image=self.bild_schema, compound=LEFT)
        self.f1r18=Radiobutton(self.frame1, variable=v, value='aeq_pro_real',   text='', indicatoron=0, command=self.hole_werte, image=self.bild_real, compound=LEFT)
        self.f1r19=Radiobutton(self.frame1, variable=v, value='aeq_met_schema', text='', indicatoron=0, command=self.hole_werte, image=self.bild_schema, compound=LEFT)
        self.f1r20=Radiobutton(self.frame1, variable=v, value='aeq_met_real',   text='', indicatoron=0, command=self.hole_werte, image=self.bild_real, compound=LEFT)
        self.f1r21=Radiobutton(self.frame1, variable=v, value='aeq_ana_schema', text='', indicatoron=0, command=self.hole_werte, image=self.bild_schema, compound=LEFT)
        self.f1r22=Radiobutton(self.frame1, variable=v, value='aeq_ana_real',   text='', indicatoron=0, command=self.hole_werte, image=self.bild_real, compound=LEFT)
        self.f1r23=Radiobutton(self.frame1, variable=v, value='aeq_tel_schema', text='', indicatoron=0, command=self.hole_werte, image=self.bild_schema, compound=LEFT)
        self.f1r24=Radiobutton(self.frame1, variable=v, value='aeq_tel_real',   text='', indicatoron=0, command=self.hole_werte, image=self.bild_real, compound=LEFT)
        # Mitose Synthesephase
        self.f1r25=Radiobutton(self.frame1, variable=v, value='mit_syn_schema', text='', indicatoron=0, command=self.hole_werte, image=self.bild_schema, compound=LEFT)
        self.f1r26=Radiobutton(self.frame1, variable=v, value='mit_syn_real',   text='', indicatoron=0, command=self.hole_werte, image=self.bild_real, compound=LEFT)
        # Befruchtung
        self.f1r27=Radiobutton(self.frame1, variable=v, value='bef_vor_schema', text='', indicatoron=0, command=self.hole_werte, image=self.bild_schema, compound=LEFT)
        self.f1r28=Radiobutton(self.frame1, variable=v, value='bef_vor_real',   text='', indicatoron=0, command=self.hole_werte, image=self.bild_real, compound=LEFT)
        self.f1r29=Radiobutton(self.frame1, variable=v, value='bef_nach_schema', text='', indicatoron=0, command=self.hole_werte, image=self.bild_schema, compound=LEFT)
        self.f1r30=Radiobutton(self.frame1, variable=v, value='bef_nach_real',  text='', indicatoron=0, command=self.hole_werte, image=self.bild_real, compound=LEFT)
        self.f1r31=Radiobutton(self.frame1, variable=v, value='bef_syn_schema', text='', indicatoron=0, command=self.hole_werte, image=self.bild_schema, compound=LEFT)
        self.f1r32=Radiobutton(self.frame1, variable=v, value='bef_syn_real',   text='', indicatoron=0, command=self.hole_werte, image=self.bild_real, compound=LEFT)
        # Rahmen 2: Auswahl männlich/weiblich bei der Äquationsteilung sowie der
        #           Anzahl der betrachteten Chromosomenpaare (mindestens zwei zur Veranschaulichung der Rekombination notwendig!)
        self.f2l1=Label(self.frame2, text='Geschlecht:')
        global g
        g=StringVar()
        #g.set('egal')
        self.f2r1=Radiobutton(self.frame2, variable=g, value='egal', text='egal', indicatoron=1, command=self.hole_werte)
        self.f2r2=Radiobutton(self.frame2, variable=g, value='m', text='♂', indicatoron=1, command=self.hole_werte)
        self.f2r3=Radiobutton(self.frame2, variable=g, value='w', text='♀', indicatoron=1, command=self.hole_werte)
        self.f2l0=Label(self.frame2, text=' ')
        self.f2l2=Label(self.frame2, text='Anzahl der dargestellten homologen Chromosomenpaare:')
        global a
        a=StringVar()
        self.f2r4=Radiobutton(self.frame2, variable=a, value='eins', text='eins', command=self.hole_werte)
        self.f2r5=Radiobutton(self.frame2, variable=a, value='zwei', text='zwei', command=self.hole_werte)
        a.set('eins')
        for i in (self.f2l1, self.f2r1, self.f2r2, self.f2r3, self.f2l2, self.f2r4, self.f2r5):
                i.config(state=DISABLED)
        # Rahmen 3: Zeichenfläche und Textbeschreibung
        self.f3canvas1=Canvas(self.frame3, width=580, height=450, bg='white')
        self.bild1=PhotoImage(file='daten/img/start.gif')
        self.f3canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
        self.f3text1=Text(self.frame3, 
                          background='white', 
                          #disabledbackground='white',
                          #disabledforeground='black',
                          height='25', 
                          width='40', 
                          wrap=WORD,
                          state=DISABLED,
                          font=('arial', '11'))
        # Rahmen 4: Übersicht zum jeweiligen Zweck
        #           Tabelle s. Übungsaufgaben
        # Rahmen 5: Navigation
        self.icon_exit=PhotoImage(file='daten/icons/dialog-close.gif')
        self.f5b1=Button(self.frame4, 
                         text='Beenden', 
                         command=root.destroy,
                         image=self.icon_exit,
                         compound=LEFT)
        self.f5b1.icon_exit=self.icon_exit

        ## Fensterelemente setzen
        for i, row, column, rowspan, columnspan, sticky in (
                                          (self.f1l1, 0, 1, 2, 2, E+W),     (self.f1l2,  0, 3, 1, 4, E+W),                                                               (self.f1l3,  0, 8, 2, 2, E+W),
                                                                            (self.f1l4,  1, 3, 1, 2, E+W), (self.f1l5,  1, 5, 1, 2, E+W), 
            (self.f1l6,  2, 0, 1, 1, E+W), (self.f1r1, 2, 1, 1, 1, E+W),    (self.f1r9,  2, 3, 1, 1, E+W), (self.f1r17, 2, 5, 1, 1, E+W), (self.f1l10, 2, 7, 4, 1, E+W), (self.f1r27, 2, 8, 2, 1, W+E+N+S),
                                           (self.f1r2, 2, 2, 1, 1, E+W),    (self.f1r10, 2, 4, 1, 1, E+W), (self.f1r18, 2, 6, 1, 1, E+W),                                (self.f1r28, 2, 9, 2, 1, W+E+N+S),
            (self.f1l7,  3, 0, 1, 1, E+W), (self.f1r3, 3, 1, 1, 1, E+W),    (self.f1r11, 3, 3, 1, 1, E+W), (self.f1r19, 3, 5, 1, 1, E+W),
                                           (self.f1r4, 3, 2, 1, 1, E+W),    (self.f1r12, 3, 4, 1, 1, E+W), (self.f1r20, 3, 6, 1, 1, E+W),
            (self.f1l8,  4, 0, 1, 1, E+W), (self.f1r5, 4, 1, 1, 1, E+W),    (self.f1r13, 4, 3, 1, 1, E+W), (self.f1r21, 4, 5, 1, 1, E+W),                                (self.f1r29, 4, 8, 2, 1, W+E+N+S),
                                           (self.f1r6, 4, 2, 1, 1, E+W),    (self.f1r14, 4, 4, 1, 1, E+W), (self.f1r22, 4, 6, 1, 1, E+W),                                (self.f1r30, 4, 9, 2, 1, W+E+N+S),
            (self.f1l9,  5, 0, 1, 1, E+W), (self.f1r7, 5, 1, 1, 1, E+W),    (self.f1r15, 5, 3, 1, 1, E+W), (self.f1r23, 5, 5, 1, 1, E+W),
                                           (self.f1r8, 5, 2, 1, 1, E+W),    (self.f1r16, 5, 4, 1, 1, E+W), (self.f1r24, 5, 6, 1, 1, E+W),
            (self.f1l11, 7, 0, 1, 1, E+W), (self.f1r25, 7, 1, 1, 1, E+W),                                                                                                (self.f1r31, 7, 8, 1, 1, E+W),
                                           (self.f1r26, 7, 2, 1, 1, E+W),                                                                                                (self.f1r32, 7, 9, 1, 1, E+W),
            (self.f2l1, 0, 0, 1, 1, E+W),  (self.f2r1, 0, 1, 1, 1, E+W), (self.f2r2, 0, 2, 1, 1, E+W), (self.f2r3, 0, 3, 1, 1, E+W), (self.f2l0, 0, 4, 1, 1, E+W), (self.f2l2, 0, 5, 1, 1, E+W),  (self.f2r4, 0, 6, 1, 1, E+W), (self.f2r5, 0, 7, 1, 1, E+W),
            (self.f3canvas1, 0, 0, 1, 1, E+W), (self.f3text1, 0, 1, 1, 1, E),

            (self.f5b1, 0, 0, 1, 1, E+W)
                ):
            i.grid(row=row, column=column, rowspan=rowspan, columnspan=columnspan, sticky=sticky)

        
        ## Schlüssel nach Geschlechtsabhängigkeit
        self.geschlechts_unabhaengige=(
            'mit_pro_schema', 'mit_pro_real', 'red_pro_schema', 'red_pro_real',
            'mit_met_schema', 'mit_met_real', 'red_met_schema', 'red_met_real',
            'mit_ana_schema', 'mit_ana_real', 'red_ana_schema', 'red_ana_real', 
            'mit_tel_schema', 'mit_tel_real', 'red_tel_schema', 'red_tel_real',
            'mit_syn_schema', 'mit_syn_real')
        
        self.geschlechts_abhaengige=(
            'aeq_pro_schema', 'aeq_pro_real',
            'aeq_met_schema', 'aeq_met_real',
            'aeq_tel_schema', 'aeq_tel_real',
            'aeq_ana_schema', 'aeq_ana_real')

        self.geschlechts_los=(
             'bef_vor_schema',  'bef_vor_real',
             'bef_nach_schema', 'bef_nach_real',
             'bef_syn_schema',  'bef_syn_real')
        ## Schlüssel nach Schema oder Realabbildung
        self.schema_knoepfe=(
            'mit_pro_schema', 'red_pro_schema', 'aeq_pro_schema', 'bef_vor_schema',
            'mit_met_schema', 'red_met_schema', 'aeq_met_schema', 
            'mit_ana_schema', 'red_ana_schema', 'aeq_tel_schema', 'bef_nach_schema',
            'mit_tel_schema', 'red_tel_schema', 'aeq_ana_schema',
            'mit_syn_schema',                                     'bef_syn_schema')
        self.real_knoepfe=(
            'mit_pro_real', 'red_pro_real', 'aeq_pro_real', 'bef_vor_real',
            'mit_met_real', 'red_met_real', 'aeq_met_real', 
            'mit_ana_real', 'red_ana_real', 'aeq_tel_real', 'bef_nach_real',
            'mit_tel_real', 'red_tel_real', 'aeq_ana_real',
            'mit_syn_real',                                  'bef_syn_real')
        
        ## Funktionen
    def hole_werte(self):
        self.phase=str(v.get())
        self.geschlecht=str(g.get())
        if self.phase in self.geschlechts_unabhaengige:
            for i in (self.f2r2, self.f2r3):
                i.config(state=DISABLED)
            self.f2r1.config(state=NORMAL)
            self.f2l1.config(state=NORMAL)
            g.set('egal')
        elif self.phase in self.geschlechts_abhaengige:
            for i in (self.f2l1,self.f2r2, self.f2r3):
                i.config(state=NORMAL)
            if self.geschlecht == 'egal' or self.geschlecht == 'X' or self.geschlecht == None or self.geschlecht == '':
                g.set('m')
            self.f2r1.config(state=DISABLED)
        elif self.phase in self.geschlechts_los:
            for i in (self.f2l1, self.f2r1, self.f2r2, self.f2r3):
                i.config(state=DISABLED)
            g.set('X')
        self.geschlecht=str(g.get())
        self.schluessel=str(self.phase+'_'+self.geschlecht)
        #print(self.schluessel)
        self.chromosomenpaarzahl=str(a.get())
        self.f3text1.config(state=NORMAL)
        self.f3text1.delete(1.0, END)
        self.beschreibungstext=str(datensammlung[self.schluessel][0])
        self.f3text1.insert(1.0, self.beschreibungstext)
        self.chromosomenpaaranzahl=str(a.get())
        if self.phase in self.schema_knoepfe:
            for i in (self.f2l2, self.f2r4, self.f2r5):
                i.config(state=NORMAL)
        elif self.phase in self.real_knoepfe:
            for i in (self.f2l2, self.f2r4, self.f2r5):
                i.config(state=DISABLED)
        self.bildername=self.schluessel+'_'+self.chromosomenpaarzahl
        # Neues Bild setzen
        try:
            self.bild1=PhotoImage(file='daten/img/'+self.bildername+'.gif')
            self.f3canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
        except:
            self.bild1=PhotoImage(file='daten/img/start.gif')
            self.f3canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
        # Schemaabbildungen unabhängig von der dargestellten Chromosomenanzahl
        if self.phase in self.real_knoepfe:
            self.bildername=self.schluessel
            try:
                self.bild1=PhotoImage(file='daten/img/'+self.phase+'.gif')
                self.f3canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
            except:
                self.bild1=PhotoImage(file='daten/img/start.gif')
                self.f3canvas1.create_image(0, 0, image=self.bild1, anchor=NW)
################################################################################
root = Tk()
root.title('Zellzykler')
app = Fenster(root)
root.mainloop()
